/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.templates;

import org.apache.shindig.gadgets.templates.TemplateLibrary;

public final class TemplateResource {
    private final String content;
    private final Type type;
    private final boolean isSafe;

    public static TemplateResource newJavascriptResource(String javascript, TemplateLibrary library) {
        return new TemplateResource(javascript, Type.JAVASCRIPT, library.isSafe());
    }

    public static TemplateResource newStyleResource(String style, TemplateLibrary library) {
        return new TemplateResource(style, Type.STYLE, library.isSafe());
    }

    private TemplateResource(String content, Type type, boolean isSafe) {
        this.content = content;
        this.type = type;
        this.isSafe = isSafe;
    }

    public String getContent() {
        return this.content;
    }

    public Type getType() {
        return this.type;
    }

    public boolean isSafe() {
        return this.isSafe;
    }

    public String toString() {
        return "<" + (Object)((Object)this.type) + ">" + this.content + "</" + (Object)((Object)this.type) + ">";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        JAVASCRIPT,
        STYLE;

    }
}

