/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.system;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.sigar.ProcCpu;
import org.hyperic.sigar.ProcCred;
import org.hyperic.sigar.ProcCredName;
import org.hyperic.sigar.ProcExe;
import org.hyperic.sigar.ProcFd;
import org.hyperic.sigar.ProcMem;
import org.hyperic.sigar.ProcState;
import org.hyperic.sigar.ProcTime;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarNotImplementedException;
import org.hyperic.sigar.SigarPermissionDeniedException;
import org.hyperic.sigar.SigarProxy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rhq.core.system.AggregateProcessInfo;
import org.rhq.core.system.OperatingSystemType;
import org.rhq.core.system.SystemInfo;
import org.rhq.core.system.SystemInfoException;
import org.rhq.core.system.SystemInfoFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessInfo {
    private final Log log = LogFactory.getLog((String)ProcessInfo.class.getName());
    protected boolean initialized;
    protected long pid;
    protected String name;
    protected String baseName;
    protected String[] commandLine;
    protected Map<String, String> environmentVariables;
    protected SigarProxy sigar;
    protected ProcState procState;
    protected ProcExe procExe;
    protected ProcTime procTime;
    protected ProcMem procMem;
    protected ProcCpu procCpu;
    protected ProcFd procFd;
    protected ProcCred procCred;
    protected ProcCredName procCredName;
    protected Map<String, String> procEnv;
    private boolean loggedPermissionsError = false;
    private static final String UNKNOWN = "?";

    protected ProcessInfo() {
    }

    public ProcessInfo(long pid) throws SystemInfoException {
        this(pid, (SigarProxy)new Sigar());
    }

    public ProcessInfo(long pid, SigarProxy sigar) throws SystemInfoException {
        this.pid = pid;
        this.sigar = sigar;
        this.update(pid);
    }

    public void refresh() throws SystemInfoException {
        this.update(this.pid);
    }

    private void update(long pid) throws SystemInfoException {
        long startTime = System.currentTimeMillis();
        try {
            ProcState procState = null;
            try {
                procState = this.sigar.getProcState(pid);
            }
            catch (Exception e) {
                this.handleSigarCallException(e, "getProcState");
            }
            ProcExe procExe = null;
            try {
                procExe = this.sigar.getProcExe(pid);
            }
            catch (Exception e) {
                this.handleSigarCallException(e, "getProcExe");
            }
            if (!this.initialized) {
                String[] procArgs = null;
                try {
                    procArgs = this.sigar.getProcArgs(pid);
                }
                catch (Exception e) {
                    this.handleSigarCallException(e, "getProcArgs");
                }
                this.name = procExe != null ? procExe.getName() : UNKNOWN;
                this.baseName = this.determineBaseName(procExe, procState);
                this.commandLine = procArgs != null ? procArgs : new String[]{};
                this.procEnv = null;
                try {
                    this.procEnv = this.sigar.getProcEnv(pid);
                    if (this.procEnv == null) {
                        this.log.debug((Object)("SIGAR returned a null environment for [" + this.baseName + "] process with pid [" + this.pid + "]."));
                    }
                }
                catch (Exception e) {
                    this.handleSigarCallException(e, "getProcEnv");
                }
                this.initialized = true;
            }
            this.procState = procState;
            this.procExe = procExe;
            try {
                this.procTime = this.sigar.getProcTime(pid);
            }
            catch (Exception e) {
                this.handleSigarCallException(e, "getProcTime");
            }
            try {
                this.procMem = this.sigar.getProcMem(pid);
            }
            catch (Exception e) {
                this.handleSigarCallException(e, "getProcMem");
            }
            try {
                this.procCpu = this.sigar.getProcCpu(pid);
            }
            catch (Exception e) {
                this.handleSigarCallException(e, "getProcCpu");
            }
            try {
                this.procFd = this.sigar.getProcFd(pid);
            }
            catch (Exception e) {
                this.handleSigarCallException(e, "getProcFd");
            }
            try {
                this.procCred = this.sigar.getProcCred(pid);
            }
            catch (Exception e) {
                this.handleSigarCallException(e, "getProcCred");
            }
            try {
                this.procCredName = this.sigar.getProcCredName(pid);
            }
            catch (Exception e) {
                this.handleSigarCallException(e, "getProcCredName");
            }
        }
        catch (Exception e) {
            throw new SystemInfoException(e);
        }
        if (this.log.isDebugEnabled()) {
            long elapsedTime = System.currentTimeMillis() - startTime;
            this.log.debug((Object)("Retrieval of process info for pid " + pid + " took " + elapsedTime + " ms."));
        }
    }

    public void destroy() throws SystemInfoException {
        if (this.sigar instanceof Sigar) {
            try {
                ((Sigar)this.sigar).close();
            }
            catch (RuntimeException e) {
                throw new SystemInfoException(e);
            }
        }
    }

    private void handleSigarCallException(Exception e, String methodName) {
        String procName;
        if (ProcessInfo.isWindows() && (this.pid == 0L || this.pid == 4L)) {
            return;
        }
        String string = procName = this.baseName != null ? this.baseName : "<unknown>";
        if (e instanceof SigarPermissionDeniedException) {
            if (!this.loggedPermissionsError) {
                String currentUserName = System.getProperty("user.name");
                this.log.trace((Object)("Unable to obtain all info for [" + procName + "] process with pid [" + this.pid + "] - call to " + methodName + "failed. " + "The process is most likely owned by a user other than the user that owns the RHQ plugin container's process (" + currentUserName + ")."));
                this.loggedPermissionsError = true;
            }
        } else if (e instanceof SigarNotImplementedException) {
            this.log.trace((Object)("Unable to obtain all info for [" + procName + "] process with pid [" + this.pid + "] - call to " + methodName + "failed. Cause: " + e));
        } else {
            this.log.debug((Object)("Unexpected error occurred while looking up info for [" + procName + "] process with pid [" + this.pid + "] - call to " + methodName + " failed. Did the process die? Cause: " + e));
        }
    }

    private static boolean isWindows() {
        return File.separatorChar == '\\';
    }

    private String determineBaseName(ProcExe exe, ProcState state) {
        int slash;
        String base = null;
        if (exe != null && (base = exe.getName()) != null && (slash = Math.max(base.lastIndexOf(92), base.lastIndexOf(47))) > -1 && slash + 1 < base.length()) {
            base = base.substring(slash + 1);
        }
        if (base == null && state != null && state.getName() != null) {
            base = state.getName();
        }
        return base != null ? base : UNKNOWN;
    }

    public long getPid() {
        return this.pid;
    }

    public String getName() {
        return this.name;
    }

    public String getBaseName() {
        return this.baseName;
    }

    public String[] getCommandLine() {
        return this.commandLine;
    }

    public Map<String, String> getEnvironmentVariables() {
        if (this.procEnv == null) {
            return Collections.emptyMap();
        }
        if (this.environmentVariables == null) {
            boolean isWindows;
            this.environmentVariables = new HashMap<String, String>(this.procEnv.size());
            SystemInfo systemInfo = SystemInfoFactory.createJavaSystemInfo();
            boolean bl = isWindows = systemInfo.getOperatingSystemType() == OperatingSystemType.WINDOWS;
            if (isWindows) {
                for (Map.Entry<String, String> env : this.procEnv.entrySet()) {
                    this.environmentVariables.put(env.getKey().toUpperCase(), env.getValue());
                }
            } else {
                this.environmentVariables.putAll(this.procEnv);
            }
        }
        return this.environmentVariables;
    }

    @Nullable
    public String getEnvironmentVariable(@NotNull String name) {
        if (this.procEnv == null) {
            return null;
        }
        SystemInfo systemInfo = SystemInfoFactory.createJavaSystemInfo();
        boolean isWindows = systemInfo.getOperatingSystemType() == OperatingSystemType.WINDOWS;
        return this.getEnvironmentVariables().get(isWindows ? name.toUpperCase() : name);
    }

    public long getParentPid() throws SystemInfoException {
        return this.procState != null ? this.procState.getPpid() : 0L;
    }

    public ProcState getState() throws SystemInfoException {
        return this.procState;
    }

    public ProcExe getExecutable() throws SystemInfoException {
        return this.procExe;
    }

    public ProcTime getTime() throws SystemInfoException {
        return this.procTime;
    }

    public ProcMem getMemory() throws SystemInfoException {
        return this.procMem;
    }

    public ProcCpu getCpu() throws SystemInfoException {
        return this.procCpu;
    }

    public ProcFd getFileDescriptor() throws SystemInfoException {
        return this.procFd;
    }

    public ProcCred getCredentials() throws SystemInfoException {
        return this.procCred;
    }

    public ProcCredName getCredentialsName() throws SystemInfoException {
        return this.procCredName;
    }

    public String getCurrentWorkingDirectory() throws SystemInfoException {
        return this.procExe.getCwd();
    }

    public boolean isRunning() throws SystemInfoException {
        boolean running = false;
        if (this.procState != null) {
            running = this.procState.getState() == 'R' || this.procState.getState() == 'S' || this.procState.getState() == 'D';
        }
        return running;
    }

    public AggregateProcessInfo getAggregateProcessTree() {
        AggregateProcessInfo root = new AggregateProcessInfo(this.pid);
        return root;
    }

    public int hashCode() {
        return Long.valueOf(this.pid).intValue();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof ProcessInfo)) {
            return false;
        }
        return this.pid == ((ProcessInfo)obj).pid;
    }

    public String toString() {
        StringBuilder s = new StringBuilder("process: ");
        s.append("pid=[");
        s.append(this.getPid());
        s.append("], name=[");
        s.append(!this.getName().equals(UNKNOWN) ? this.getName() : this.getBaseName());
        s.append("], ppid=[");
        try {
            s.append(this.getParentPid());
        }
        catch (Exception e) {
            s.append(e);
        }
        s.append("]");
        return s.toString();
    }
}

