/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.connector.fckeditor;

import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.servlet.ServletContext;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Response;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.dom.DOMSource;
import org.exoplatform.commons.utils.LazyPageList;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.ComponentRequestLifecycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.Query;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PageNavigation;
import org.exoplatform.portal.config.model.PageNode;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.pom.config.POMSession;
import org.exoplatform.portal.pom.config.POMSessionManager;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Path(value="/portalLinks/")
public class PortalLinkConnector
implements ResourceContainer {
    private final String PUBLIC_ACCESS = "public".intern();
    private final String PRIVATE_ACCESS = "private".intern();
    private final String EVERYONE_PERMISSION = "Everyone".intern();
    private final String RESOURCE_TYPE = "PortalPageURI".intern();
    private DataStorage portalDataStorage;
    private UserACL portalUserACL;
    private ServletContext servletContext;
    private static Log log = ExoLogger.getLogger(PortalLinkConnector.class);
    private POMSessionManager manager;
    private POMSession session;

    public PortalLinkConnector(InitParams params, DataStorage dataStorage, UserACL userACL, ServletContext servletContext) throws Exception {
        this.portalDataStorage = dataStorage;
        this.portalUserACL = userACL;
        this.servletContext = servletContext;
        this.manager = (POMSessionManager)WCMCoreUtils.getService(POMSessionManager.class);
    }

    @GET
    @Path(value="/getFoldersAndFiles/")
    public Response getPageURI(@QueryParam(value="currentFolder") String currentFolder, @QueryParam(value="command") String command, @QueryParam(value="type") String type) throws Exception {
        try {
            String userId = this.getCurrentUser();
            return this.buildReponse(currentFolder, command, userId);
        }
        catch (Exception e) {
            log.error((Object)"Error when perform getPageURI: ", e.fillInStackTrace());
            return Response.ok().build();
        }
    }

    private String getCurrentUser() {
        try {
            ConversationState conversationState = ConversationState.getCurrent();
            return conversationState.getIdentity().getUserId();
        }
        catch (Exception e) {
            log.error((Object)"Error when perform getCurrentUser: ", e.fillInStackTrace());
            return null;
        }
    }

    private Response buildReponse(String currentFolder, String command, String userId) throws Exception {
        Document document = null;
        document = currentFolder == null || "/".equals(currentFolder) ? this.buildPortalXMLResponse("/", command, userId) : this.buildNavigationXMLResponse(currentFolder, command, userId);
        CacheControl cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
        return Response.ok((Object)new DOMSource(document), (String)"text/xml").cacheControl(cacheControl).build();
    }

    private Document buildPortalXMLResponse(String currentFolder, String command, String userId) throws Exception {
        if (this.manager.getSession() == null) {
            this.session = this.manager.openSession();
        }
        Element rootElement = this.initRootElement(command, currentFolder);
        Query query = new Query(null, null, null, null, PortalConfig.class);
        LazyPageList pageList = this.portalDataStorage.find(query, (Comparator)new Comparator<PortalConfig>(){

            @Override
            public int compare(PortalConfig pconfig1, PortalConfig pconfig2) {
                return pconfig1.getName().compareTo(pconfig2.getName());
            }
        });
        Element foldersElement = rootElement.getOwnerDocument().createElement("Folders");
        rootElement.appendChild(foldersElement);
        for (Object object : pageList.getAll()) {
            PortalConfig config = (PortalConfig)object;
            if (!this.portalUserACL.hasPermission(config)) continue;
            Element folderElement = rootElement.getOwnerDocument().createElement("Folder");
            folderElement.setAttribute("name", config.getName());
            folderElement.setAttribute("url", "");
            folderElement.setAttribute("folderType", "");
            foldersElement.appendChild(folderElement);
        }
        this.session.close();
        return rootElement.getOwnerDocument();
    }

    private Document buildNavigationXMLResponse(String currentFolder, String command, String userId) throws Exception {
        if (this.manager.getSession() == null) {
            this.session = this.manager.openSession();
        }
        PortalContainer container = PortalContainer.getInstance();
        OrganizationService organizationService = (OrganizationService)WCMCoreUtils.getService(OrganizationService.class);
        ((ComponentRequestLifecycle)organizationService).startRequest((ExoContainer)container);
        Element rootElement = this.initRootElement(command, currentFolder);
        String portalName = currentFolder.substring(1, currentFolder.indexOf(47, 1));
        String pageNodeUri = currentFolder.substring(portalName.length() + 1);
        UserPortalConfigService pConfig = (UserPortalConfigService)WCMCoreUtils.getService(UserPortalConfigService.class);
        List navigations = pConfig.getUserPortalConfig(portalName, userId).getNavigations();
        Element foldersElement = rootElement.getOwnerDocument().createElement("Folders");
        Element filesElement = rootElement.getOwnerDocument().createElement("Files");
        rootElement.appendChild(foldersElement);
        rootElement.appendChild(filesElement);
        for (PageNavigation navigation : navigations) {
            for (PageNode pageNode : navigation.getNodes()) {
                if ("/".equalsIgnoreCase(pageNodeUri)) {
                    this.processPageNode(portalName, pageNode, foldersElement, filesElement, userId, pConfig);
                    continue;
                }
                PageNode node = this.getPageNode(pageNode, pageNodeUri);
                if (node == null || node.getChildren() == null) continue;
                for (PageNode child : node.getChildren()) {
                    this.processPageNode(portalName, child, foldersElement, filesElement, userId, pConfig);
                }
            }
        }
        ((ComponentRequestLifecycle)organizationService).endRequest((ExoContainer)container);
        this.session.close();
        return rootElement.getOwnerDocument();
    }

    private Element initRootElement(String commandStr, String currentPath) throws ParserConfigurationException {
        Document doc = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        doc = builder.newDocument();
        Element rootElement = doc.createElement("Connector");
        doc.appendChild(rootElement);
        rootElement.setAttribute("command", commandStr);
        rootElement.setAttribute("resourceType", this.RESOURCE_TYPE);
        Element myEl = doc.createElement("CurrentFolder");
        myEl.setAttribute("path", currentPath);
        myEl.setAttribute("url", "");
        rootElement.appendChild(myEl);
        return rootElement;
    }

    private void processPageNode(String portalName, PageNode pageNode, Element foldersElement, Element filesElement, String userId, UserPortalConfigService portalConfigService) throws Exception {
        if (!pageNode.isDisplay()) {
            return;
        }
        String pageId = pageNode.getPageReference();
        Page page = portalConfigService.getPage(pageId, userId);
        if (page == null) {
            return;
        }
        String accessMode = this.PRIVATE_ACCESS;
        for (String role : page.getAccessPermissions()) {
            if (!this.EVERYONE_PERMISSION.equalsIgnoreCase(role)) continue;
            accessMode = this.PUBLIC_ACCESS;
            break;
        }
        String pageUri = "/" + this.servletContext.getServletContextName() + "/" + accessMode + "/" + portalName + "/" + pageNode.getUri();
        Element folderElement = foldersElement.getOwnerDocument().createElement("Folder");
        folderElement.setAttribute("name", pageNode.getName());
        folderElement.setAttribute("folderType", "");
        folderElement.setAttribute("url", pageUri);
        foldersElement.appendChild(folderElement);
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        String datetime = formatter.format(new Date());
        Element fileElement = filesElement.getOwnerDocument().createElement("File");
        fileElement.setAttribute("name", pageNode.getName());
        fileElement.setAttribute("dateCreated", datetime);
        fileElement.setAttribute("fileType", "page node");
        fileElement.setAttribute("url", pageUri);
        fileElement.setAttribute("size", "");
        filesElement.appendChild(fileElement);
    }

    private PageNode getPageNode(PageNode root, String uri) {
        if (uri.equals("/" + root.getUri() + "/")) {
            return root;
        }
        List list = root.getChildren();
        if (list == null) {
            return null;
        }
        for (PageNode child : list) {
            if (uri.equals("/" + child.getUri() + "/")) {
                return child;
            }
            PageNode deepChild = this.getPageNode(child, uri);
            if (deepChild == null) continue;
            return deepChild;
        }
        return null;
    }
}

