/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.pdmodel.graphics.color;

import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.io.IOException;
import org.pdfbox.cos.COSArray;
import org.pdfbox.cos.COSBase;
import org.pdfbox.cos.COSDictionary;
import org.pdfbox.cos.COSFloat;
import org.pdfbox.cos.COSName;
import org.pdfbox.pdmodel.common.PDRange;
import org.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.pdfbox.pdmodel.graphics.color.PDTristimulus;

public class PDLab
extends PDColorSpace {
    public static final String NAME = "Lab";
    private COSArray array;
    private COSDictionary dictionary;

    public PDLab() {
        this.array = new COSArray();
        this.dictionary = new COSDictionary();
        this.array.add(COSName.getPDFName(NAME));
        this.array.add(this.dictionary);
    }

    public PDLab(COSArray lab) {
        this.array = lab;
        this.dictionary = (COSDictionary)this.array.getObject(1);
    }

    public String getName() {
        return NAME;
    }

    public COSBase getCOSObject() {
        return this.array;
    }

    public ColorSpace createColorSpace() throws IOException {
        throw new IOException("Not implemented");
    }

    public ColorModel createColorModel(int bpc) throws IOException {
        throw new IOException("Not implemented");
    }

    public int getNumberOfComponents() throws IOException {
        return 3;
    }

    public PDTristimulus getWhitepoint() {
        COSArray wp = (COSArray)this.dictionary.getDictionaryObject(COSName.getPDFName("WhitePoint"));
        if (wp == null) {
            wp = new COSArray();
            wp.add(new COSFloat(1.0f));
            wp.add(new COSFloat(1.0f));
            wp.add(new COSFloat(1.0f));
            this.dictionary.setItem(COSName.getPDFName("WhitePoint"), (COSBase)wp);
        }
        return new PDTristimulus(wp);
    }

    public void setWhitepoint(PDTristimulus wp) {
        COSBase wpArray = wp.getCOSObject();
        if (wpArray != null) {
            this.dictionary.setItem(COSName.getPDFName("WhitePoint"), wpArray);
        }
    }

    public PDTristimulus getBlackPoint() {
        COSArray bp = (COSArray)this.dictionary.getDictionaryObject(COSName.getPDFName("BlackPoint"));
        if (bp == null) {
            bp = new COSArray();
            bp.add(new COSFloat(0.0f));
            bp.add(new COSFloat(0.0f));
            bp.add(new COSFloat(0.0f));
            this.dictionary.setItem(COSName.getPDFName("BlackPoint"), (COSBase)bp);
        }
        return new PDTristimulus(bp);
    }

    public void setBlackPoint(PDTristimulus bp) {
        COSBase bpArray = null;
        if (bp != null) {
            bpArray = bp.getCOSObject();
        }
        this.dictionary.setItem(COSName.getPDFName("BlackPoint"), bpArray);
    }

    private COSArray getRangeArray() {
        COSArray range = (COSArray)this.dictionary.getDictionaryObject(COSName.getPDFName("Range"));
        if (range == null) {
            range = new COSArray();
            this.dictionary.setItem(COSName.getPDFName("Range"), (COSBase)this.array);
            range.add(new COSFloat(-100.0f));
            range.add(new COSFloat(100.0f));
            range.add(new COSFloat(-100.0f));
            range.add(new COSFloat(100.0f));
        }
        return range;
    }

    public PDRange getARange() {
        COSArray range = this.getRangeArray();
        return new PDRange(range, 0);
    }

    public void setARange(PDRange range) {
        COSArray rangeArray = null;
        if (range == null) {
            rangeArray = this.getRangeArray();
            rangeArray.set(0, new COSFloat(-100.0f));
            rangeArray.set(1, new COSFloat(100.0f));
        } else {
            rangeArray = range.getCOSArray();
        }
        this.dictionary.setItem(COSName.getPDFName("Range"), (COSBase)rangeArray);
    }

    public PDRange getBRange() {
        COSArray range = this.getRangeArray();
        return new PDRange(range, 1);
    }

    public void setBRange(PDRange range) {
        COSArray rangeArray = null;
        if (range == null) {
            rangeArray = this.getRangeArray();
            rangeArray.set(2, new COSFloat(-100.0f));
            rangeArray.set(3, new COSFloat(100.0f));
        } else {
            rangeArray = range.getCOSArray();
        }
        this.dictionary.setItem(COSName.getPDFName("Range"), (COSBase)rangeArray);
    }
}

