/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.impl.store.ldap;

import java.util.Hashtable;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import org.picketlink.idm.common.exception.IdentityException;
import org.picketlink.idm.impl.store.ldap.LDAPIdentityStoreConfiguration;
import org.picketlink.idm.spi.store.IdentityStoreSession;

public class LDAPIdentityStoreSessionImpl
implements IdentityStoreSession {
    private final LDAPIdentityStoreConfiguration storeConfig;

    public LDAPIdentityStoreSessionImpl(LDAPIdentityStoreConfiguration storeConfig) {
        this.storeConfig = storeConfig;
    }

    public LdapContext getLdapContext() throws Exception {
        if (this.storeConfig.getExternalJNDIContext() != null) {
            InitialContext iniCtx = new InitialContext();
            return (LdapContext)iniCtx.lookup(this.storeConfig.getExternalJNDIContext());
        }
        if (this.storeConfig.getCustomSystemProperties() != null && this.storeConfig.getCustomSystemProperties().size() > 0) {
            Map<String, String> props = this.storeConfig.getCustomSystemProperties();
            for (String name : props.keySet()) {
                System.setProperty(name, props.get(name));
            }
        }
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        if (this.storeConfig.getProviderURL() != null) {
            env.put("java.naming.provider.url", this.storeConfig.getProviderURL());
        }
        if (this.storeConfig.getAdminDN() != null) {
            env.put("java.naming.security.principal", this.storeConfig.getAdminDN());
        }
        if (this.storeConfig.getAdminPassword() != null) {
            env.put("java.naming.security.credentials", this.storeConfig.getAdminPassword());
        }
        if (this.storeConfig.getAuthenticationMethod() != null) {
            env.put("java.naming.security.authentication", this.storeConfig.getAuthenticationMethod());
        } else {
            env.put("java.naming.security.authentication", "simple");
        }
        if (this.storeConfig.getCustomJNDIConnectionParameters() != null && this.storeConfig.getCustomJNDIConnectionParameters().size() > 0) {
            Map<String, String> params = this.storeConfig.getCustomJNDIConnectionParameters();
            for (String name : params.keySet()) {
                env.put(name, params.get(name));
            }
        }
        return new InitialLdapContext(env, null);
    }

    public Object getSessionContext() throws IdentityException {
        try {
            return this.getLdapContext();
        }
        catch (Exception e) {
            throw new IdentityException("Could not create LdapContext", (Throwable)e);
        }
    }

    public void close() throws IdentityException {
    }

    public void save() throws IdentityException {
    }

    public void clear() throws IdentityException {
    }

    public boolean isOpen() {
        return false;
    }

    public boolean isTransactionSupported() {
        return false;
    }

    public void startTransaction() {
    }

    public void commitTransaction() {
    }

    public void rollbackTransaction() {
    }

    public boolean isTransactionActive() {
        return false;
    }
}

