/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.portlet.PortletPreferences;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.ecm.webui.component.explorer.UIDriveSelector;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorerPortlet;
import org.exoplatform.ecm.webui.component.explorer.UIJcrExplorerEditContainer;
import org.exoplatform.ecm.webui.form.UIFormInputSetWithAction;
import org.exoplatform.ecm.webui.selector.UISelectable;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.cms.drives.DriveData;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.validator.NumberFormatValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIFormWithTitle.gtmpl", events={@EventConfig(phase=Event.Phase.DECODE, listeners={SaveActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={EditActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={CancelActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={SelectTypeActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={SelectDriveActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={SelectNodePathActionListener.class})})
public class UIJcrExplorerEditForm
extends UIForm
implements UISelectable {
    private boolean flagSelectRender = false;
    public static final String PARAM_PATH_ACTION = "SelectNodePath";
    public static final String PARAM_PATH_INPUT = "nodePath";
    private static final String POPUP_SELECT_PATH_INPUT = "PopupSelectPath";

    public UIJcrExplorerEditForm() throws Exception {
        UIFormSelectBox repository = new UIFormSelectBox("repository", "repository", this.getRepoOption());
        String repositoryValue = this.getPreference().getValue("repository", "");
        repository.setValue(repositoryValue);
        repository.setEnable(false);
        this.addChild((UIComponent)repository);
        UIFormCheckBoxInput checkBoxCategory = new UIFormCheckBoxInput("categoryMandatoryWhenFileUpload", null, null);
        checkBoxCategory.setChecked(Boolean.parseBoolean(this.getPreference().getValue("categoryMandatoryWhenFileUpload", "")));
        checkBoxCategory.setEnable(false);
        this.addChild((UIComponent)checkBoxCategory);
        UIFormStringInput uiMaxSizeUpload = new UIFormStringInput("uploadFileSizeLimitMB", "uploadFileSizeLimitMB", null);
        uiMaxSizeUpload.addValidator(NumberFormatValidator.class, new Object[0]);
        uiMaxSizeUpload.setValue((Object)this.getPreference().getValue("uploadFileSizeLimitMB", ""));
        uiMaxSizeUpload.setEditable(false);
        this.addChild((UIComponent)uiMaxSizeUpload);
        ArrayList<SelectItemOption> listType = new ArrayList<SelectItemOption>();
        String usecase = this.getPreference().getValue("usecase", "");
        listType.add(new SelectItemOption("Selection", (Object)"selection"));
        listType.add(new SelectItemOption("Jailed", (Object)"jailed"));
        listType.add(new SelectItemOption("Personal", (Object)"personal"));
        listType.add(new SelectItemOption("Social", (Object)"social"));
        listType.add(new SelectItemOption("Parameterize", (Object)"parameterize"));
        UIFormSelectBox typeSelectBox = new UIFormSelectBox("usecase", "usecase", listType);
        typeSelectBox.setValue(usecase);
        typeSelectBox.setEnable(false);
        typeSelectBox.setOnChange("SelectType");
        this.addChild((UIComponent)typeSelectBox);
        UIFormInputSetWithAction driveNameInput = new UIFormInputSetWithAction("DriveNameInput");
        UIFormStringInput stringInputDrive = new UIFormStringInput("driveName", "driveName", null);
        stringInputDrive.setValue((Object)this.getPreference().getValue("driveName", ""));
        stringInputDrive.setEnable(false);
        driveNameInput.addUIFormInput((UIFormInput)stringInputDrive);
        driveNameInput.setActionInfo("driveName", new String[]{"SelectDrive"});
        this.addUIComponentInput((UIComponent)driveNameInput);
        UIFormInputSetWithAction uiParamPathInput = new UIFormInputSetWithAction(PARAM_PATH_ACTION);
        UIFormStringInput pathInput = new UIFormStringInput(PARAM_PATH_INPUT, PARAM_PATH_INPUT, null);
        pathInput.setValue((Object)this.getPreference().getValue(PARAM_PATH_INPUT, ""));
        pathInput.setEnable(false);
        uiParamPathInput.addUIFormInput((UIFormInput)pathInput);
        uiParamPathInput.setActionInfo(PARAM_PATH_INPUT, new String[]{PARAM_PATH_ACTION});
        this.addUIComponentInput((UIComponent)uiParamPathInput);
        driveNameInput.setRendered(true);
        uiParamPathInput.setRendered(false);
        if (usecase.equals("jailed")) {
            this.setFlagSelectRender(true);
        } else if (usecase.equals("personal")) {
            driveNameInput.setRendered(false);
            this.setFlagSelectRender(true);
        } else if (usecase.equals("social")) {
            driveNameInput.setRendered(false);
            this.getGroupId();
            this.setFlagSelectRender(true);
        } else if (usecase.equals("parameterize")) {
            uiParamPathInput.setRendered(true);
            this.setFlagSelectRender(true);
        }
        this.setActions(new String[]{"Edit"});
    }

    public String getGroupId() {
        try {
            Method[] methods;
            PortalRequestContext pcontext = Util.getPortalRequestContext();
            String requestUrl = pcontext.getRequestURI();
            String portalUrl = pcontext.getPortalURI();
            String spaceUrl = requestUrl.replace(portalUrl, "");
            if (spaceUrl.contains("/")) {
                spaceUrl = spaceUrl.split("/")[0];
            }
            Object space = this.getSpaceByUrl(spaceUrl);
            Class<?> clazzSpace = Class.forName("org.exoplatform.social.space.Space");
            for (Method m : methods = clazzSpace.getDeclaredMethods()) {
                if (!m.getName().trim().equals("getGroupId")) continue;
                return (String)m.invoke(space, new Object[0]);
            }
        }
        catch (Exception e) {
            UIFormSelectBox typeSelectBox = (UIFormSelectBox)this.getChildById("usecase");
            typeSelectBox.setValue("selection");
            UIFormInputSetWithAction driveNameInput = (UIFormInputSetWithAction)this.getChildById("DriveNameInput");
            UIFormStringInput stringInputDrive = driveNameInput.getUIStringInput("driveName");
            stringInputDrive.setValue((Object)"");
            UIApplication uiApp = (UIApplication)this.getAncestorOfType(UIApplication.class);
            uiApp.addMessage(new ApplicationMessage("UIJcrExplorerEditForm.msg.not-have-social", null));
        }
        return null;
    }

    public Object getSpaceByUrl(String url) throws Exception {
        try {
            Method[] methods;
            Class<?> clazz = Class.forName("org.exoplatform.social.space.SpaceService");
            Object obj = PortalContainer.getInstance().getComponentInstanceOfType(clazz);
            for (Method m : methods = clazz.getDeclaredMethods()) {
                if (!m.getName().trim().equals("getSpaceByUrl")) continue;
                return m.invoke(obj, url);
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    public boolean isFlagSelectRender() {
        return this.flagSelectRender;
    }

    public void setFlagSelectRender(boolean flagSelectRender) {
        this.flagSelectRender = flagSelectRender;
    }

    public void setEditable(boolean isEditable) {
        UIFormSelectBox repository = (UIFormSelectBox)this.getChild(UIFormSelectBox.class);
        repository.setEnable(isEditable);
        UIFormCheckBoxInput checkBoxCategory = (UIFormCheckBoxInput)this.getChildById("categoryMandatoryWhenFileUpload");
        checkBoxCategory.setEnable(isEditable);
        UIFormSelectBox typeSelectBox = (UIFormSelectBox)this.getChildById("usecase");
        typeSelectBox.setEnable(isEditable);
        UIFormStringInput uiMaxFileSize = (UIFormStringInput)this.getChildById("uploadFileSizeLimitMB");
        uiMaxFileSize.setEditable(isEditable);
    }

    private PortletPreferences getPreference() {
        PortletRequestContext pcontext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        return pcontext.getRequest().getPreferences();
    }

    private List<SelectItemOption<String>> getRepoOption() throws Exception {
        ArrayList<SelectItemOption<String>> options = new ArrayList<SelectItemOption<String>>();
        RepositoryService repositoryService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        for (RepositoryEntry repo : repositoryService.getConfig().getRepositoryConfigurations()) {
            options.add((SelectItemOption<String>)new SelectItemOption(repo.getName(), (Object)repo.getName()));
        }
        return options;
    }

    public void doSelect(String selectField, Object value) throws Exception {
        String stValue = null;
        stValue = "/".equals(String.valueOf(value)) ? "/" : (String.valueOf(value).split(":/").length > 1 ? String.valueOf(value).split(":/")[1] : "/");
        ((UIFormStringInput)this.findComponentById(selectField)).setValue((Object)stValue);
        UIJcrExplorerEditContainer uiContainer = (UIJcrExplorerEditContainer)this.getParent();
        for (UIComponent uiChild : uiContainer.getChildren()) {
            if (!uiChild.getId().equals(POPUP_SELECT_PATH_INPUT)) continue;
            UIPopupWindow uiPopup = (UIPopupWindow)uiContainer.getChildById(uiChild.getId());
            uiPopup.setRendered(false);
            uiPopup.setShow(false);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SelectNodePathActionListener
    extends EventListener<UIJcrExplorerEditForm> {
        public void execute(Event<UIJcrExplorerEditForm> event) throws Exception {
            UIJcrExplorerEditForm uiForm = (UIJcrExplorerEditForm)((Object)event.getSource());
            UIJcrExplorerEditContainer editContainer = (UIJcrExplorerEditContainer)uiForm.getParent();
            UIFormInputSetWithAction driveNameInput = (UIFormInputSetWithAction)uiForm.getChildById("DriveNameInput");
            UIFormStringInput stringInputDrive = driveNameInput.getUIStringInput("driveName");
            String driveName = (String)stringInputDrive.getValue();
            UIFormSelectBox repository = (UIFormSelectBox)uiForm.getChild(UIFormSelectBox.class);
            if (repository.isEnable()) {
                if (driveName == null || driveName.length() == 0) {
                    UIApplication uiApp = (UIApplication)uiForm.getAncestorOfType(UIApplication.class);
                    uiApp.addMessage(new ApplicationMessage("UIJcrExplorerEditForm.msg.personal-usecase", null, 1));
                    return;
                }
            } else {
                UIApplication uiApp = (UIApplication)uiForm.getAncestorOfType(UIApplication.class);
                uiApp.addMessage(new ApplicationMessage("UIJcrExplorerEditForm.msg.path-edit-permission", null, 1));
                return;
            }
            editContainer.initPopupDriveBrowser(UIJcrExplorerEditForm.POPUP_SELECT_PATH_INPUT, driveName);
            event.getRequestContext().addUIComponentToUpdateByAjax(uiForm.getParent());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SelectDriveActionListener
    extends EventListener<UIJcrExplorerEditForm> {
        public void execute(Event<UIJcrExplorerEditForm> event) throws Exception {
            UIJcrExplorerEditForm uiForm = (UIJcrExplorerEditForm)((Object)event.getSource());
            UIJcrExplorerEditContainer editContainer = (UIJcrExplorerEditContainer)uiForm.getParent();
            UIFormSelectBox repository = (UIFormSelectBox)uiForm.getChild(UIFormSelectBox.class);
            if (!repository.isEnable()) {
                UIApplication uiApp = (UIApplication)uiForm.getAncestorOfType(UIApplication.class);
                uiApp.addMessage(new ApplicationMessage("UIJcrExplorerEditForm.msg.drive-edit-permission", null, 1));
                return;
            }
            UIPopupWindow popupWindow = editContainer.initPopup("PopUpSelectDrive");
            UIDriveSelector driveSelector = (UIDriveSelector)editContainer.createUIComponent(UIDriveSelector.class, null, null);
            driveSelector.updateGrid();
            popupWindow.setUIComponent((UIComponent)driveSelector);
            event.getRequestContext().addUIComponentToUpdateByAjax(uiForm.getParent());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SaveActionListener
    extends EventListener<UIJcrExplorerEditForm> {
        public void execute(Event<UIJcrExplorerEditForm> event) throws Exception {
            UIJcrExplorerEditForm uiForm = (UIJcrExplorerEditForm)((Object)event.getSource());
            PortletPreferences pref = uiForm.getPreference();
            UIFormSelectBox repository = (UIFormSelectBox)uiForm.getChildById("repository");
            UIFormCheckBoxInput checkBoxCategory = (UIFormCheckBoxInput)uiForm.getChildById("categoryMandatoryWhenFileUpload");
            UIFormStringInput uiMaxFileSize = uiForm.getUIStringInput("uploadFileSizeLimitMB");
            UIFormSelectBox typeSelectBox = (UIFormSelectBox)uiForm.getChildById("usecase");
            UIFormInputSetWithAction driveNameInput = (UIFormInputSetWithAction)uiForm.getChildById("DriveNameInput");
            UIFormStringInput stringInputDrive = driveNameInput.getUIStringInput("driveName");
            String nodePath = (String)((UIFormStringInput)uiForm.findComponentById(UIJcrExplorerEditForm.PARAM_PATH_INPUT)).getValue();
            String driveName = (String)stringInputDrive.getValue();
            String useCase = (String)typeSelectBox.getValue();
            if (useCase.equals("jailed")) {
                if (driveName == null || driveName.length() == 0) {
                    UIApplication uiApp = (UIApplication)uiForm.getAncestorOfType(UIApplication.class);
                    uiApp.addMessage(new ApplicationMessage("UIJcrExplorerEditForm.msg.notNullDriveName", null, 1));
                    return;
                }
            } else if (useCase.equals("parameterize") && (nodePath == null || nodePath.length() == 0)) {
                UIApplication uiApp = (UIApplication)uiForm.getAncestorOfType(UIApplication.class);
                uiApp.addMessage(new ApplicationMessage("UIJcrExplorerEditForm.msg.notNullPath", null, 1));
                return;
            }
            if (useCase.equals("selection")) {
                nodePath = "/";
            } else {
                uiForm.setFlagSelectRender(true);
            }
            pref.setValue("repository", (String)repository.getValue());
            pref.setValue("categoryMandatoryWhenFileUpload", String.valueOf(checkBoxCategory.isChecked()));
            pref.setValue("uploadFileSizeLimitMB", String.valueOf(uiMaxFileSize.getValue()));
            pref.setValue("usecase", useCase);
            pref.setValue("driveName", driveName);
            pref.setValue(UIJcrExplorerEditForm.PARAM_PATH_INPUT, nodePath);
            pref.store();
            uiForm.setEditable(false);
            uiForm.setActions(new String[]{"Edit"});
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiForm);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SelectTypeActionListener
    extends EventListener<UIJcrExplorerEditForm> {
        public void execute(Event<UIJcrExplorerEditForm> event) throws Exception {
            UIJcrExplorerEditForm uiForm = (UIJcrExplorerEditForm)((Object)event.getSource());
            UIJCRExplorerPortlet uiJExplorerPortlet = (UIJCRExplorerPortlet)uiForm.getAncestorOfType(UIJCRExplorerPortlet.class);
            uiForm.setEditable(true);
            UIFormSelectBox typeSelectBox = (UIFormSelectBox)uiForm.getChildById("usecase");
            UIFormInputSetWithAction driveNameInput = (UIFormInputSetWithAction)uiForm.getChildById("DriveNameInput");
            UIFormInputSetWithAction uiParamPathInput = (UIFormInputSetWithAction)uiForm.getChildById(UIJcrExplorerEditForm.PARAM_PATH_ACTION);
            driveNameInput.setRendered(true);
            uiParamPathInput.setRendered(false);
            if (((String)typeSelectBox.getValue()).equals("jailed")) {
                UIFormStringInput stringInputDrive = driveNameInput.getUIStringInput("driveName");
                stringInputDrive.setValue((Object)"");
                driveNameInput.setRendered(true);
            } else if (((String)typeSelectBox.getValue()).equals("social")) {
                String groupId = uiForm.getGroupId();
                if (groupId == null || groupId.equals("")) {
                    UIFormStringInput stringInputDrive = driveNameInput.getUIStringInput("driveName");
                    stringInputDrive.setValue((Object)"");
                } else {
                    groupId = groupId.replaceAll("/", ".");
                    UIFormStringInput stringInputDrive = driveNameInput.getUIStringInput("driveName");
                    stringInputDrive.setValue((Object)groupId);
                }
                driveNameInput.setRendered(false);
            } else if (((String)typeSelectBox.getValue()).equals("personal")) {
                DriveData personalPrivateDrive = uiJExplorerPortlet.getUserDrive(uiJExplorerPortlet.getPreferenceRepository(), "private");
                UIFormStringInput stringInputDrive = driveNameInput.getUIStringInput("driveName");
                stringInputDrive.setValue((Object)personalPrivateDrive.getName());
                driveNameInput.setRendered(false);
                UIApplication uiApp = (UIApplication)uiForm.getAncestorOfType(UIApplication.class);
                uiApp.addMessage(new ApplicationMessage("UIJcrExplorerEditForm.msg.personal-usecase", null));
            } else if (((String)typeSelectBox.getValue()).equals("parameterize")) {
                UIFormStringInput stringInputDrive = driveNameInput.getUIStringInput("driveName");
                stringInputDrive.setValue((Object)"");
                driveNameInput.setRendered(true);
                UIFormStringInput stringInputDrivePath = uiParamPathInput.getUIStringInput(UIJcrExplorerEditForm.PARAM_PATH_INPUT);
                stringInputDrivePath.setValue((Object)"");
                uiParamPathInput.setRendered(true);
            }
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiForm);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CancelActionListener
    extends EventListener<UIJcrExplorerEditForm> {
        public void execute(Event<UIJcrExplorerEditForm> event) throws Exception {
            UIJcrExplorerEditForm uiForm = (UIJcrExplorerEditForm)((Object)event.getSource());
            PortletPreferences pref = uiForm.getPreference();
            UIFormSelectBox repository = (UIFormSelectBox)uiForm.getChildById("repository");
            repository.setValue(pref.getValue("repository", ""));
            UIFormCheckBoxInput checkBoxCategory = (UIFormCheckBoxInput)uiForm.getChildById("categoryMandatoryWhenFileUpload");
            checkBoxCategory.setChecked(Boolean.parseBoolean(pref.getValue("categoryMandatoryWhenFileUpload", "")));
            UIFormSelectBox typeSelectBox = (UIFormSelectBox)uiForm.getChildById("usecase");
            typeSelectBox.setValue(pref.getValue("usecase", ""));
            UIFormInputSetWithAction driveNameInput = (UIFormInputSetWithAction)uiForm.getChildById("DriveNameInput");
            UIFormStringInput stringInputDrive = driveNameInput.getUIStringInput("driveName");
            stringInputDrive.setValue((Object)pref.getValue("driveName", ""));
            UIFormInputSetWithAction uiParamPathInput = (UIFormInputSetWithAction)uiForm.getChildById(UIJcrExplorerEditForm.PARAM_PATH_ACTION);
            UIFormStringInput stringInputPath = uiParamPathInput.getUIStringInput(UIJcrExplorerEditForm.PARAM_PATH_INPUT);
            stringInputPath.setValue((Object)pref.getValue(UIJcrExplorerEditForm.PARAM_PATH_INPUT, ""));
            if (pref.getValue("usecase", "").equals("jailed")) {
                driveNameInput.setRendered(true);
                uiParamPathInput.setRendered(false);
            } else if (pref.getValue("usecase", "").equals("parameterize")) {
                driveNameInput.setRendered(true);
                uiParamPathInput.setRendered(true);
            } else {
                driveNameInput.setRendered(false);
                uiParamPathInput.setRendered(false);
            }
            UIFormStringInput uiMaxFileSize = uiForm.getUIStringInput("uploadFileSizeLimitMB");
            uiMaxFileSize.setValue((Object)pref.getValue("uploadFileSizeLimitMB", ""));
            uiForm.setEditable(false);
            uiForm.setActions(new String[]{"Edit"});
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiForm);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EditActionListener
    extends EventListener<UIJcrExplorerEditForm> {
        public void execute(Event<UIJcrExplorerEditForm> event) throws Exception {
            UIJcrExplorerEditForm uiForm = (UIJcrExplorerEditForm)((Object)event.getSource());
            UIFormInputSetWithAction driveNameInput = (UIFormInputSetWithAction)uiForm.getChildById("DriveNameInput");
            driveNameInput.setActionInfo("driveName", new String[]{"SelectDrive"});
            uiForm.setEditable(true);
            uiForm.setActions(new String[]{"Save", "Cancel"});
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiForm);
        }
    }
}

