/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.interactive.annotation;

import java.io.IOException;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionFactory;
import org.apache.pdfbox.pdmodel.interactive.action.type.PDAction;
import org.apache.pdfbox.pdmodel.interactive.action.type.PDActionURI;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDBorderStyleDictionary;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.destination.PDDestination;

public class PDAnnotationLink
extends PDAnnotation {
    public static final String HIGHLIGHT_MODE_NONE = "N";
    public static final String HIGHLIGHT_MODE_INVERT = "I";
    public static final String HIGHLIGHT_MODE_OUTLINE = "O";
    public static final String HIGHLIGHT_MODE_PUSH = "P";
    public static final String SUB_TYPE = "Link";

    public PDAnnotationLink() {
        this.getDictionary().setItem(COSName.SUBTYPE, (COSBase)COSName.getPDFName(SUB_TYPE));
    }

    public PDAnnotationLink(COSDictionary field) {
        super(field);
    }

    public PDAction getAction() throws IOException {
        COSDictionary action = (COSDictionary)this.getDictionary().getDictionaryObject(COSName.A);
        return PDActionFactory.createAction(action);
    }

    public void setAction(PDAction action) {
        this.getDictionary().setItem(COSName.A, (COSObjectable)action);
    }

    public void setBorderStyle(PDBorderStyleDictionary bs) {
        this.getDictionary().setItem("BS", (COSObjectable)bs);
    }

    public PDBorderStyleDictionary getBorderStyle() {
        COSDictionary bs = (COSDictionary)this.getDictionary().getItem(COSName.getPDFName("BS"));
        if (bs != null) {
            return new PDBorderStyleDictionary(bs);
        }
        return null;
    }

    public PDDestination getDestination() throws IOException {
        COSBase base = this.getDictionary().getDictionaryObject(COSName.DEST);
        PDDestination retval = PDDestination.create(base);
        return retval;
    }

    public void setDestination(PDDestination dest) {
        this.getDictionary().setItem(COSName.DEST, (COSObjectable)dest);
    }

    public String getHighlightMode() {
        return this.getDictionary().getNameAsString(COSName.H, HIGHLIGHT_MODE_INVERT);
    }

    public void setHighlightMode(String mode) {
        this.getDictionary().setName(COSName.H, mode);
    }

    public void setPreviousURI(PDActionURI pa) {
        this.getDictionary().setItem("PA", (COSObjectable)pa);
    }

    public PDActionURI getPreviousURI() {
        COSDictionary pa = (COSDictionary)this.getDictionary().getDictionaryObject("PA");
        if (pa != null) {
            return new PDActionURI(pa);
        }
        return null;
    }

    public void setQuadPoints(float[] quadPoints) {
        COSArray newQuadPoints = new COSArray();
        newQuadPoints.setFloatArray(quadPoints);
        this.getDictionary().setItem("QuadPoints", (COSBase)newQuadPoints);
    }

    public float[] getQuadPoints() {
        COSArray quadPoints = (COSArray)this.getDictionary().getDictionaryObject("QuadPoints");
        if (quadPoints != null) {
            return quadPoints.toFloatArray();
        }
        return null;
    }
}

