/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.dataflow;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeDataManager;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.SessionDataManager;
import org.exoplatform.services.jcr.impl.dataflow.AbstractItemDataCopyVisitor;
import org.exoplatform.services.jcr.impl.dataflow.TransientNodeData;
import org.exoplatform.services.jcr.impl.dataflow.TransientPropertyData;
import org.exoplatform.services.jcr.impl.dataflow.TransientValueData;
import org.exoplatform.services.jcr.util.IdGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DefaultItemDataCopyVisitor
extends AbstractItemDataCopyVisitor {
    protected InternalQName destNodeName;
    protected Stack<NodeData> parents;
    protected List<ItemState> itemAddStates = new ArrayList<ItemState>();
    protected boolean keepIdentifiers;
    protected NodeTypeDataManager ntManager;
    protected QPath ancestorToSave = null;

    public DefaultItemDataCopyVisitor(NodeData parent, InternalQName destNodeName, NodeTypeDataManager nodeTypeManager, SessionDataManager dataManager, boolean keepIdentifiers) {
        super(dataManager);
        this.keepIdentifiers = keepIdentifiers;
        this.ntManager = nodeTypeManager;
        this.destNodeName = destNodeName;
        this.parents = new Stack();
        this.parents.add(parent);
    }

    @Override
    protected void entering(PropertyData property, int level) throws RepositoryException {
        List<ValueData> values;
        InternalQName qname = property.getQPath().getName();
        if (this.ntManager.isNodeType(Constants.MIX_REFERENCEABLE, this.curParent().getPrimaryTypeName(), this.curParent().getMixinTypeNames()) && qname.equals((Object)Constants.JCR_UUID)) {
            values = new ArrayList<ValueData>(1);
            values.add(new TransientValueData(this.curParent().getIdentifier()));
        } else {
            values = this.copyValues(property);
        }
        TransientPropertyData newProperty = new TransientPropertyData(QPath.makeChildPath(this.curParent().getQPath(), qname), this.keepIdentifiers ? property.getIdentifier() : IdGenerator.generate(), -1, property.getType(), this.curParent().getIdentifier(), property.isMultiValued(), values);
        this.itemAddStates.add(new ItemState(newProperty, 1, true, this.ancestorToSave, level != 0));
    }

    @Override
    protected void entering(NodeData node, int level) throws RepositoryException {
        if (this.ancestorToSave == null) {
            this.ancestorToSave = this.curParent().getQPath();
        }
        NodeData parent = this.curParent();
        QPath qpath = this.calculateNewNodePath(node, level);
        int orderNum = 0;
        orderNum = this.ntManager.isOrderableChildNodesSupported(parent.getPrimaryTypeName(), parent.getMixinTypeNames()) ? this.calculateNewNodeOrderNumber() : node.getOrderNumber();
        String id = this.keepIdentifiers ? node.getIdentifier() : IdGenerator.generate();
        TransientNodeData newNode = new TransientNodeData(qpath, id, -1, node.getPrimaryTypeName(), node.getMixinTypeNames(), orderNum, parent.getIdentifier(), node.getACL());
        this.parents.push(newNode);
        this.itemAddStates.add(new ItemState(newNode, 1, true, this.ancestorToSave, level != 0));
    }

    @Override
    protected void leaving(PropertyData property, int level) throws RepositoryException {
    }

    @Override
    protected void leaving(NodeData node, int level) throws RepositoryException {
        this.parents.pop();
    }

    protected NodeData curParent() {
        return this.parents.peek();
    }

    public List<ItemState> getItemAddStates() {
        return this.itemAddStates;
    }

    protected List<ItemState> findItemStates(QPath itemPath) {
        ArrayList<ItemState> istates = new ArrayList<ItemState>();
        for (ItemState istate : this.itemAddStates) {
            if (!istate.getData().getQPath().equals(itemPath)) continue;
            istates.add(istate);
        }
        return istates;
    }

    protected ItemState findLastItemState(QPath itemPath) {
        for (int i = this.itemAddStates.size() - 1; i >= 0; --i) {
            ItemState istate = this.itemAddStates.get(i);
            if (!istate.getData().getQPath().equals(itemPath)) continue;
            return istate;
        }
        return null;
    }

    protected int calculateNewNodeOrderNumber() throws RepositoryException {
        return this.dataManager.getChildNodesCount(this.curParent());
    }

    protected QPath calculateNewNodePath(NodeData node, int level) throws RepositoryException {
        NodeData parent = this.curParent();
        InternalQName qname = null;
        List<NodeData> existedChilds = this.dataManager.getChildNodesData(parent);
        int newIndex = 1;
        if (level == 0) {
            qname = this.destNodeName;
            for (NodeData child : existedChilds) {
                if (!child.getQPath().getName().equals((Object)qname)) continue;
                ++newIndex;
            }
        } else {
            qname = node.getQPath().getName();
            newIndex = node.getQPath().getIndex();
        }
        return QPath.makeChildPath(parent.getQPath(), qname, newIndex);
    }
}

