/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.common.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gatein.common.util.MultiValuedPropertyMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleMultiValuedPropertyMap<T>
implements MultiValuedPropertyMap<T> {
    private Map<String, LinkedList<T>> content;

    @Override
    public void addValue(String key, T value) {
        LinkedList<Object> values;
        if (key == null) {
            throw new IllegalArgumentException("Name cannot be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("Value cannot be null");
        }
        if (this.content == null) {
            this.content = new HashMap<String, LinkedList<T>>();
        }
        if ((values = this.content.get(key)) == null) {
            values = new LinkedList();
            this.content.put(key, values);
        }
        values.add(value);
    }

    @Override
    public void setValue(String key, T value) {
        LinkedList<Object> values;
        if (key == null) {
            throw new IllegalArgumentException("Name cannot be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("Value cannot be null");
        }
        if (this.content == null) {
            this.content = new HashMap<String, LinkedList<T>>();
        }
        if ((values = this.content.get(key)) == null) {
            values = new LinkedList();
            this.content.put(key, values);
        } else {
            values.clear();
        }
        values.add(value);
    }

    @Override
    public void clear() {
        if (this.content != null) {
            this.content.clear();
        }
    }

    @Override
    public T getValue(String key) throws IllegalArgumentException {
        if (key == null) {
            throw new IllegalArgumentException("Name cannot be null");
        }
        if (this.content == null) {
            return null;
        }
        LinkedList<T> values = this.content.get(key);
        if (values == null) {
            return null;
        }
        return values.get(0);
    }

    @Override
    public List<T> getValues(String key) {
        if (key == null) {
            throw new IllegalArgumentException("Name cannot be null");
        }
        if (this.content == null) {
            return null;
        }
        return this.content.get(key);
    }

    @Override
    public Set<String> keySet() {
        if (this.content == null) {
            return Collections.emptySet();
        }
        return this.content.keySet();
    }

    @Override
    public int size() {
        if (this.content == null) {
            return 0;
        }
        return this.content.size();
    }

    @Override
    public void append(MultiValuedPropertyMap<T> appended) throws IllegalArgumentException {
        block8: {
            block7: {
                if (appended == null) {
                    throw new IllegalArgumentException();
                }
                if (!(appended instanceof SimpleMultiValuedPropertyMap)) break block7;
                Map<String, LinkedList<T>> appendedContent = ((SimpleMultiValuedPropertyMap)appended).content;
                if (appendedContent == null) break block8;
                for (Map.Entry<String, LinkedList<T>> entry : appendedContent.entrySet()) {
                    LinkedList<T> values;
                    String name = entry.getKey();
                    if (this.content == null) {
                        this.content = new HashMap<String, LinkedList<T>>(appendedContent.size());
                    }
                    if ((values = this.content.get(name)) != null) {
                        values.addAll((Collection)entry.getValue());
                        continue;
                    }
                    this.content.put(name, new LinkedList(entry.getValue()));
                }
                break block8;
            }
            for (String key : appended.keySet()) {
                List<T> values = appended.getValues(key);
                if (this.content == null) {
                    this.content = new HashMap<String, LinkedList<T>>(appended.size());
                }
                if (values != null) {
                    values.addAll(values);
                    continue;
                }
                this.content.put(key, new LinkedList<T>(values));
            }
        }
    }
}

