/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import org.jgroups.ExtendedMessageListener;
import org.jgroups.Message;
import org.jgroups.MessageListener;

public class MessageListenerAdapter
implements ExtendedMessageListener {
    protected MessageListener stateListener;
    protected final HashSet messageListeners = new HashSet();
    protected MessageListener[] messageListenersCache = new MessageListener[0];

    public MessageListenerAdapter() {
        this(null);
    }

    public MessageListenerAdapter(MessageListener mainListener) {
        if (mainListener != null) {
            this.stateListener = mainListener;
            this.addMessageListener(mainListener);
        }
    }

    public byte[] getState() {
        if (this.stateListener != null) {
            return this.stateListener.getState();
        }
        return null;
    }

    public byte[] getState(String state_id) {
        if (this.stateListener == null) {
            return null;
        }
        if (this.stateListener instanceof ExtendedMessageListener) {
            return ((ExtendedMessageListener)this.stateListener).getState(state_id);
        }
        return this.stateListener.getState();
    }

    public void getState(OutputStream ostream) {
        if (this.stateListener instanceof ExtendedMessageListener) {
            ((ExtendedMessageListener)this.stateListener).getState(ostream);
        }
    }

    public void getState(String state_id, OutputStream ostream) {
        if (this.stateListener instanceof ExtendedMessageListener && state_id != null) {
            ((ExtendedMessageListener)this.stateListener).getState(state_id, ostream);
        }
    }

    public void receive(Message msg) {
        for (int i = 0; i < this.messageListenersCache.length; ++i) {
            this.messageListenersCache[i].receive(msg);
        }
    }

    public void setState(byte[] state) {
        if (this.stateListener != null) {
            this.stateListener.setState(state);
        }
    }

    public void setState(String state_id, byte[] state) {
        if (this.stateListener != null) {
            if (this.stateListener instanceof ExtendedMessageListener) {
                ((ExtendedMessageListener)this.stateListener).setState(state_id, state);
            } else {
                this.stateListener.setState(state);
            }
        }
    }

    public void setState(InputStream istream) {
        if (this.stateListener instanceof ExtendedMessageListener) {
            ((ExtendedMessageListener)this.stateListener).setState(istream);
        }
    }

    public void setState(String state_id, InputStream istream) {
        if (this.stateListener instanceof ExtendedMessageListener && state_id != null) {
            ((ExtendedMessageListener)this.stateListener).setState(state_id, istream);
        }
    }

    public final synchronized void addMessageListener(MessageListener listener) {
        if (this.messageListeners.add(listener)) {
            this.messageListenersCache = this.messageListeners.toArray(new MessageListener[this.messageListeners.size()]);
        }
    }

    public synchronized void removeMessageListener(MessageListener listener) {
        if (this.messageListeners.remove(listener)) {
            this.messageListenersCache = this.messageListeners.toArray(new MessageListener[this.messageListeners.size()]);
        }
    }

    public void setStateListener(MessageListener listener) {
        this.stateListener = listener;
    }
}

