/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.core.vt;

import java.io.InputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.ValueFormatException;
import org.chromattic.core.vt.ValueType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseValueType<E, I>
extends ValueType<E> {
    private final List<E> defaultValues;
    private final Class<E> objectType;
    private final Class<?> realType;

    protected BaseValueType(List<E> defaultValues, Class<E> objectType, Class<?> realType) {
        this.defaultValues = defaultValues;
        this.objectType = objectType;
        this.realType = realType;
    }

    @Override
    public List<E> getDefaultValue() {
        return this.defaultValues;
    }

    @Override
    public boolean isPrimitive() {
        return this.realType.isPrimitive();
    }

    public abstract E toExternal(I var1);

    public abstract I toInternal(E var1);

    @Override
    public Class<E> getObjectType() {
        return this.objectType;
    }

    @Override
    public Class<?> getRealType() {
        return this.realType;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class DATE<V>
    extends BaseValueType<V, Date> {
        public DATE(List<V> defaultValues, Class<V> objectType, Class<?> realType) {
            super(defaultValues, objectType, realType);
        }

        @Override
        public V get(Value value) throws RepositoryException {
            int propertyType = value.getType();
            if (propertyType == 5) {
                return (V)this.toExternal(value.getDate().getTime());
            }
            throw new ClassCastException();
        }

        @Override
        public Value get(ValueFactory valueFactory, V o) throws ValueFormatException {
            Date time = (Date)this.toInternal(o);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(time);
            return valueFactory.createValue(calendar);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class TO_DATE
        extends DATE<Date> {
            public TO_DATE(List<Date> defaultValues, Class<?> realType) {
                super(defaultValues, Date.class, realType);
            }

            @Override
            public Date toExternal(Date internal) {
                return internal;
            }

            @Override
            public Date toInternal(Date external) {
                return external;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class BOOLEAN<V>
    extends BaseValueType<V, Boolean> {
        public BOOLEAN(List<V> defaultValues, Class<V> objectType, Class<?> realType) {
            super(defaultValues, objectType, realType);
        }

        @Override
        public V get(Value value) throws RepositoryException {
            int propertyType = value.getType();
            if (propertyType == 6) {
                return (V)this.toExternal(value.getBoolean());
            }
            throw new ClassCastException();
        }

        @Override
        public Value get(ValueFactory valueFactory, V o) throws ValueFormatException {
            Boolean b = (Boolean)this.toInternal(o);
            return valueFactory.createValue(b.booleanValue());
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class TO_BOOLEAN
        extends BOOLEAN<Boolean> {
            public TO_BOOLEAN(List<Boolean> defaultValues, Class<?> realType) {
                super(defaultValues, Boolean.class, realType);
            }

            @Override
            public Boolean toExternal(Boolean internal) {
                return internal;
            }

            @Override
            public Boolean toInternal(Boolean external) {
                return external;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class DOUBLE<V>
    extends BaseValueType<V, Double> {
        public DOUBLE(List<V> defaultValues, Class<V> objectType, Class<?> realType) {
            super(defaultValues, objectType, realType);
        }

        @Override
        public V get(Value value) throws RepositoryException {
            int propertyType = value.getType();
            if (propertyType == 4) {
                return (V)this.toExternal(value.getDouble());
            }
            throw new ClassCastException();
        }

        @Override
        public Value get(ValueFactory valueFactory, V o) throws ValueFormatException {
            Double d = (Double)this.toInternal(o);
            return valueFactory.createValue(d.doubleValue());
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class TO_FLOAT
        extends DOUBLE<Float> {
            public TO_FLOAT(List<Float> defaultValues, Class<?> realType) {
                super(defaultValues, Float.class, realType);
            }

            @Override
            public Float toExternal(Double internal) {
                return Float.valueOf(internal.floatValue());
            }

            @Override
            public Double toInternal(Float external) {
                return external.doubleValue();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class TO_DOUBLE
        extends DOUBLE<Double> {
            public TO_DOUBLE(List<Double> defaultValues, Class<?> realType) {
                super(defaultValues, Double.class, realType);
            }

            @Override
            public Double toExternal(Double internal) {
                return internal;
            }

            @Override
            public Double toInternal(Double external) {
                return external;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class LONG<V>
    extends BaseValueType<V, Long> {
        public LONG(List<V> defaultValues, Class<V> objectType, Class<?> realType) {
            super(defaultValues, objectType, realType);
        }

        @Override
        public V get(Value value) throws RepositoryException {
            int propertyType = value.getType();
            if (propertyType == 3) {
                return (V)this.toExternal(value.getLong());
            }
            throw new ClassCastException();
        }

        @Override
        public Value get(ValueFactory valueFactory, V o) throws ValueFormatException {
            Long l = (Long)this.toInternal(o);
            return valueFactory.createValue(l.longValue());
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class TO_LONG
        extends LONG<Long> {
            public TO_LONG(List<Long> defaultValues, Class<?> realType) {
                super(defaultValues, Long.class, realType);
            }

            @Override
            public Long toExternal(Long internal) {
                return internal;
            }

            @Override
            public Long toInternal(Long external) {
                return external;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class TO_INT
        extends LONG<Integer> {
            public TO_INT(List<Integer> defaultValues, Class<?> realType) {
                super(defaultValues, Integer.class, realType);
            }

            @Override
            public Integer toExternal(Long internal) {
                return internal.intValue();
            }

            @Override
            public Long toInternal(Integer external) {
                return external.longValue();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class PATH<V>
    extends BaseValueType<V, String> {
        public PATH(List<V> defaultValues, Class<V> objectType, Class<?> realType) {
            super(defaultValues, objectType, realType);
        }

        @Override
        public V get(Value value) throws RepositoryException {
            int propertyType = value.getType();
            if (propertyType == 8) {
                return (V)this.toExternal(value.getString());
            }
            throw new ClassCastException();
        }

        @Override
        public Value get(ValueFactory valueFactory, V o) throws ValueFormatException {
            String s = (String)this.toInternal(o);
            return valueFactory.createValue(s, 8);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class TO_STRING
        extends PATH<String> {
            public TO_STRING(List<String> defaultValues, Class<?> realType) {
                super(defaultValues, String.class, realType);
            }

            @Override
            public String toExternal(String internal) {
                return internal;
            }

            @Override
            public String toInternal(String external) {
                return external;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class STREAM<V>
    extends BaseValueType<V, InputStream> {
        public STREAM(List<V> defaultValues, Class<V> objectType, Class<?> realType) {
            super(defaultValues, objectType, realType);
        }

        @Override
        public V get(Value value) throws RepositoryException {
            int propertyType = value.getType();
            if (propertyType == 2) {
                return (V)this.toExternal(value.getStream());
            }
            throw new ClassCastException();
        }

        @Override
        public Value get(ValueFactory valueFactory, V o) throws ValueFormatException {
            InputStream in = (InputStream)this.toInternal(o);
            return valueFactory.createValue(in);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class TO_STREAM
        extends STREAM<InputStream> {
            public TO_STREAM(List<InputStream> defaultValues, Class<?> realType) {
                super(defaultValues, InputStream.class, realType);
            }

            @Override
            public InputStream toExternal(InputStream internal) {
                return internal;
            }

            @Override
            public InputStream toInternal(InputStream external) {
                return external;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class STRING<V>
    extends BaseValueType<V, String> {
        public STRING(List<V> defaultValues, Class<V> objectType, Class<?> realType) {
            super(defaultValues, objectType, realType);
        }

        @Override
        public V get(Value value) throws RepositoryException {
            int propertyType = value.getType();
            if (propertyType == 1 || propertyType == 7 || propertyType == 8) {
                return (V)this.toExternal(value.getString());
            }
            throw new ClassCastException();
        }

        @Override
        public Value get(ValueFactory valueFactory, V o) throws ValueFormatException {
            String s = (String)this.toInternal(o);
            return valueFactory.createValue(s);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class TO_STRING
        extends STRING<String> {
            public TO_STRING(List<String> defaultValues, Class<?> realType) {
                super(defaultValues, String.class, realType);
            }

            @Override
            public String toExternal(String internal) {
                return internal;
            }

            @Override
            public String toInternal(String external) {
                return external;
            }
        }
    }
}

