/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.documentinterchange.markedcontent.PDMarkedContent;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDXObject;
import org.apache.pdfbox.util.PDFStreamEngine;
import org.apache.pdfbox.util.ResourceLoader;
import org.apache.pdfbox.util.TextNormalize;
import org.apache.pdfbox.util.TextPosition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PDFMarkedContentExtractor
extends PDFStreamEngine {
    private boolean suppressDuplicateOverlappingText = true;
    private List<PDMarkedContent> markedContents = new ArrayList<PDMarkedContent>();
    private Stack<PDMarkedContent> currentMarkedContents = new Stack();
    private Map<String, List<TextPosition>> characterListMapping = new HashMap<String, List<TextPosition>>();
    protected String outputEncoding;
    private TextNormalize normalize = null;

    public PDFMarkedContentExtractor() throws IOException {
        super(ResourceLoader.loadProperties("Resources/PDFMarkedContentExtractor.properties", true));
        this.outputEncoding = null;
        this.normalize = new TextNormalize(this.outputEncoding);
    }

    public PDFMarkedContentExtractor(Properties props) throws IOException {
        super(props);
        this.outputEncoding = null;
        this.normalize = new TextNormalize(this.outputEncoding);
    }

    public PDFMarkedContentExtractor(String encoding) throws IOException {
        super(ResourceLoader.loadProperties("Resources/PDFMarkedContentExtractor.properties", true));
        this.outputEncoding = encoding;
        this.normalize = new TextNormalize(this.outputEncoding);
    }

    private boolean within(float first, float second, float variance) {
        return second > first - variance && second < first + variance;
    }

    public void beginMarkedContentSequence(COSName tag, COSDictionary properties) {
        PDMarkedContent markedContent = new PDMarkedContent(tag, properties);
        if (this.currentMarkedContents.isEmpty()) {
            this.markedContents.add(markedContent);
        } else {
            PDMarkedContent currentMarkedContent = this.currentMarkedContents.peek();
            if (currentMarkedContent != null) {
                currentMarkedContent.addMarkedContent(markedContent);
            }
        }
        this.currentMarkedContents.push(markedContent);
    }

    public void endMarkedContentSequence() {
        if (!this.currentMarkedContents.isEmpty()) {
            this.currentMarkedContents.pop();
        }
    }

    public void xobject(PDXObject xobject) {
        if (!this.currentMarkedContents.isEmpty()) {
            this.currentMarkedContents.peek().addXObject(xobject);
        }
    }

    @Override
    protected void processTextPosition(TextPosition text) {
        boolean showCharacter = true;
        if (this.suppressDuplicateOverlappingText) {
            showCharacter = false;
            String textCharacter = text.getCharacter();
            float textX = text.getX();
            float textY = text.getY();
            List<TextPosition> sameTextCharacters = this.characterListMapping.get(textCharacter);
            if (sameTextCharacters == null) {
                sameTextCharacters = new ArrayList<TextPosition>();
                this.characterListMapping.put(textCharacter, sameTextCharacters);
            }
            boolean suppressCharacter = false;
            float tolerance = text.getWidth() / (float)textCharacter.length() / 3.0f;
            for (int i = 0; i < sameTextCharacters.size() && textCharacter != null; ++i) {
                TextPosition character = sameTextCharacters.get(i);
                String charCharacter = character.getCharacter();
                float charX = character.getX();
                float charY = character.getY();
                if (charCharacter == null || !this.within(charX, textX, tolerance) || !this.within(charY, textY, tolerance)) continue;
                suppressCharacter = true;
            }
            if (!suppressCharacter) {
                sameTextCharacters.add(text);
                showCharacter = true;
            }
        }
        if (showCharacter) {
            ArrayList<TextPosition> textList = new ArrayList<TextPosition>();
            if (textList.isEmpty()) {
                textList.add(text);
            } else {
                TextPosition previousTextPosition = (TextPosition)textList.get(textList.size() - 1);
                if (text.isDiacritic() && previousTextPosition.contains(text)) {
                    previousTextPosition.mergeDiacritic(text, this.normalize);
                } else if (previousTextPosition.isDiacritic() && text.contains(previousTextPosition)) {
                    text.mergeDiacritic(previousTextPosition, this.normalize);
                    textList.remove(textList.size() - 1);
                    textList.add(text);
                } else {
                    textList.add(text);
                }
            }
            if (!this.currentMarkedContents.isEmpty()) {
                this.currentMarkedContents.peek().addText(text);
            }
        }
    }

    public List<PDMarkedContent> getMarkedContents() {
        return this.markedContents;
    }
}

