/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.REST.viewer;

import com.artofsolving.jodconverter.openoffice.connection.OpenOfficeException;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.ConnectException;
import javax.imageio.ImageIO;
import javax.jcr.Node;
import javax.jcr.Session;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.cms.jodconverter.JodConverterService;
import org.exoplatform.services.cms.mimetype.DMSMimeTypeResolver;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.icepdf.core.exceptions.PDFException;
import org.icepdf.core.exceptions.PDFSecurityException;
import org.icepdf.core.pobjects.Document;

@Path(value="/pdfviewer/{repoName}/{workspaceName}/{pageNumber}/{rotation}/{scale}/{uuid}/")
public class PDFViewerRESTService
implements ResourceContainer {
    private static final String LASTMODIFIED = "Last-Modified";
    private RepositoryService repositoryService_;
    private ExoCache<Serializable, Object> pdfCache;
    private JodConverterService jodConverter_;
    private static final Log LOG = ExoLogger.getLogger((String)PDFViewerRESTService.class.getName());

    public PDFViewerRESTService(RepositoryService repositoryService, CacheService caService, JodConverterService jodConverter) throws Exception {
        this.repositoryService_ = repositoryService;
        this.jodConverter_ = jodConverter;
        this.pdfCache = caService.getCacheInstance(PDFViewerRESTService.class.getName());
    }

    @GET
    public Response getCoverImage(@PathParam(value="repoName") String repoName, @PathParam(value="workspaceName") String wsName, @PathParam(value="uuid") String uuid, @PathParam(value="pageNumber") String pageNumber, @PathParam(value="rotation") String rotation, @PathParam(value="scale") String scale) throws Exception {
        return this.getImageByPageNumber(repoName, wsName, uuid, pageNumber, rotation, scale);
    }

    private Response getImageByPageNumber(String repoName, String wsName, String uuid, String pageNumber, String strRotation, String strScale) throws Exception {
        StringBuilder bd = new StringBuilder();
        StringBuilder bd1 = new StringBuilder();
        bd.append(repoName).append("/").append(wsName).append("/").append(uuid);
        Session session = null;
        try {
            Object objCache = this.pdfCache.get((Serializable)new ObjectKey(bd.toString()));
            InputStream is = null;
            ManageableRepository repository = this.repositoryService_.getCurrentRepository();
            session = this.getSystemProvider().getSession(wsName, repository);
            Node currentNode = session.getNodeByUUID(uuid);
            if (objCache != null) {
                File content = new File((String)this.pdfCache.get((Serializable)new ObjectKey(bd.toString())));
                if (!content.exists()) {
                    this.initDocument(currentNode, repoName);
                }
                is = this.pushToCache(new File((String)this.pdfCache.get((Serializable)new ObjectKey(bd.toString()))), repoName, wsName, uuid, pageNumber, strRotation, strScale);
            } else {
                File file = this.getPDFDocumentFile(currentNode, repoName);
                is = this.pushToCache(file, repoName, wsName, uuid, pageNumber, strRotation, strScale);
            }
            String lastModified = (String)this.pdfCache.get((Serializable)new ObjectKey(bd1.append(bd.toString()).append("/jcr:lastModified").toString()));
            return Response.ok((Object)is, (String)"image").header(LASTMODIFIED, (Object)lastModified).build();
        }
        catch (Exception e) {
            LOG.error((Object)e);
            return Response.ok().build();
        }
    }

    private SessionProvider getSystemProvider() {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        SessionProviderService service = (SessionProviderService)container.getComponentInstanceOfType(SessionProviderService.class);
        return service.getSystemSessionProvider(null);
    }

    private InputStream pushToCache(File content, String repoName, String wsName, String uuid, String pageNumber, String strRotation, String strScale) throws FileNotFoundException {
        StringBuilder bd = new StringBuilder();
        bd.append(repoName).append("/").append(wsName).append("/").append(uuid).append("/").append(pageNumber).append("/").append(strRotation).append("/").append(strScale);
        String filePath = (String)this.pdfCache.get((Serializable)new ObjectKey(bd.toString()));
        if (filePath == null || !new File(filePath).exists()) {
            File file = this.buildFileImage(content, uuid, pageNumber, strRotation, strScale);
            filePath = file.getPath();
            this.pdfCache.put((Serializable)new ObjectKey(bd.toString()), (Object)filePath);
        }
        return new BufferedInputStream(new FileInputStream(new File(filePath)));
    }

    private Document buildDocumentImage(File input, String name) {
        Document document = new Document();
        try {
            document.setInputStream((InputStream)new BufferedInputStream(new FileInputStream(input)), name);
        }
        catch (PDFException ex) {
            LOG.error((Object)("Error parsing PDF document " + (Object)((Object)ex)));
        }
        catch (PDFSecurityException ex) {
            LOG.error((Object)("Error encryption not supported " + (Object)((Object)ex)));
        }
        catch (FileNotFoundException ex) {
            LOG.error((Object)("Error file not found " + ex));
        }
        catch (IOException ex) {
            LOG.error((Object)("Error handling PDF document " + ex));
        }
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File buildFileImage(File input, String path, String pageNumber, String strRotation, String strScale) {
        BufferedImage image;
        Document document = this.buildDocumentImage(input, path);
        float scale = Float.parseFloat(strScale);
        float rotation = Float.parseFloat(strRotation);
        int maximumOfPage = document.getNumberOfPages();
        int pageNum = 1;
        try {
            pageNum = Integer.parseInt(pageNumber);
        }
        catch (NumberFormatException e) {
            pageNum = 1;
        }
        if (pageNum >= maximumOfPage) {
            pageNum = maximumOfPage;
        } else if (pageNum < 1) {
            pageNum = 1;
        }
        BufferedImage rendImage = image = (BufferedImage)document.getPageImage(pageNum - 1, 1, 2, rotation, scale);
        File file = null;
        try {
            file = File.createTempFile("imageCapture1_" + pageNum, ".png");
            file.deleteOnExit();
            ImageIO.write((RenderedImage)rendImage, "png", file);
        }
        catch (IOException e) {
            LOG.error((Object)e);
        }
        finally {
            image.flush();
            document.dispose();
        }
        return file;
    }

    public Document initDocument(Node currentNode, String repoName) throws Exception {
        return this.buildDocumentImage(this.getPDFDocumentFile(currentNode, repoName), currentNode.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getPDFDocumentFile(Node currentNode, String repoName) throws Exception {
        String wsName = currentNode.getSession().getWorkspace().getName();
        String uuid = currentNode.getUUID();
        StringBuilder bd = new StringBuilder();
        StringBuilder bd1 = new StringBuilder();
        bd.append(repoName).append("/").append(wsName).append("/").append(uuid);
        String path = (String)this.pdfCache.get((Serializable)new ObjectKey(bd.toString()));
        File content = null;
        String name = currentNode.getName();
        if (path == null || !(content = new File(path)).exists()) {
            Node contentNode = currentNode.getNode("jcr:content");
            String mimeType = contentNode.getProperty("jcr:mimeType").getString();
            BufferedInputStream input = new BufferedInputStream(contentNode.getProperty("jcr:data").getStream());
            if (name.indexOf(".") > 0) {
                name = name.substring(0, name.indexOf("."));
            }
            content = File.createTempFile(name, ".pdf");
            content.deleteOnExit();
            String extension = DMSMimeTypeResolver.getInstance().getExtension(mimeType);
            if ("pdf".equals(extension)) {
                this.read(input, new BufferedOutputStream(new FileOutputStream(content)));
            } else {
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(content));
                try {
                    this.jodConverter_.convert((InputStream)input, extension, (OutputStream)out, "pdf");
                }
                catch (ConnectException connection) {
                    content.delete();
                    LOG.error((Object)"Cannot open connection to OpenOffice Service");
                }
                catch (OpenOfficeException connection) {
                    content.delete();
                    LOG.error((Object)"Exception when using OpenOffice Service");
                }
                finally {
                    ((OutputStream)out).flush();
                    ((OutputStream)out).close();
                }
            }
            if (content.exists() && contentNode.hasProperty("jcr:lastModified")) {
                String lastModified = contentNode.getProperty("jcr:lastModified").getString();
                this.pdfCache.put((Serializable)new ObjectKey(bd.toString()), (Object)content.getPath());
                this.pdfCache.put((Serializable)new ObjectKey(bd1.append(bd.toString()).append("/jcr:lastModified").toString()), (Object)lastModified);
            }
        }
        return content;
    }

    private void read(InputStream is, OutputStream os) throws Exception {
        int bufferLength = 1024;
        int readLength = 0;
        while (readLength > -1) {
            byte[] chunk = new byte[bufferLength];
            readLength = is.read(chunk);
            if (readLength <= 0) continue;
            os.write(chunk, 0, readLength);
        }
        os.flush();
        os.close();
    }

    private class ObjectKey
    implements Serializable {
        String key;

        private ObjectKey(String key) {
            this.key = key;
        }

        public String toString() {
            return this.key;
        }

        public void finalize() {
            String path = (String)PDFViewerRESTService.this.pdfCache.get((Serializable)new ObjectKey(this.key));
            File f = new File(path);
            if (f.exists()) {
                f.delete();
            }
        }

        public String getKey() {
            return this.key;
        }

        public int hashCode() {
            return this.key == null ? -1 : this.key.length();
        }

        public boolean equals(Object otherKey) {
            return otherKey != null && ObjectKey.class.isInstance(otherKey) && this.key != null && this.key.equals(((ObjectKey)otherKey).getKey());
        }
    }
}

