/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.popup.actions;

import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.version.VersionException;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.form.UIFormInputSetWithAction;
import org.exoplatform.ecm.webui.selector.UISelectable;
import org.exoplatform.ecm.webui.tree.selectone.UIOneNodePathSelector;
import org.exoplatform.ecm.webui.utils.JCRExceptionManager;
import org.exoplatform.portal.webui.util.SessionProviderFactory;
import org.exoplatform.services.cms.documents.TrashService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputSet;
import org.exoplatform.webui.form.UIFormStringInput;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={AddActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE)})
public class UISelectRestorePath
extends UIForm
implements UIPopupComponent,
UISelectable {
    public static final String FIELD_PATH = "PathNode";
    public static final String FORM_INPUT = "formInput";
    public static final String POPUP_PATH = "UIPopupPathFoRestore";
    public static final String FORM_MESSAGE = "UIFormMessage";
    public static final String CHOOSE_PATH_TO_RESTORE_NODE = "ChooseTagToRestoreNode";
    private static final Log LOG = ExoLogger.getLogger(UISelectRestorePath.class);
    private NodeLocation trashHomeNode;
    private String repository;
    private String srcPath;

    public Node getTrashHomeNode() {
        return NodeLocation.getNodeByLocation((NodeLocation)this.trashHomeNode);
    }

    public void setTrashHomeNode(Node trashHomeNode) {
        this.trashHomeNode = NodeLocation.getNodeLocationByNode((Node)trashHomeNode);
    }

    public String getRepository() {
        return this.repository;
    }

    public void setRepository(String repository) {
        this.repository = repository;
    }

    public String getSrcPath() {
        return this.srcPath;
    }

    public void setSrcPath(String srcPath) {
        this.srcPath = srcPath;
    }

    public void activate() throws Exception {
        UIFormInputSetWithAction uiFormInputAction = new UIFormInputSetWithAction("UIFormInputSetWithAction");
        UIFormStringInput homePathField = new UIFormStringInput(FORM_INPUT, FORM_INPUT, null);
        homePathField.setValue((Object)"");
        homePathField.setEditable(false);
        uiFormInputAction.addUIFormInput((UIFormInput)homePathField);
        uiFormInputAction.setId(FIELD_PATH);
        uiFormInputAction.setActionInfo(FORM_INPUT, new String[]{"Add"});
        this.addUIFormInput((UIFormInputSet)uiFormInputAction);
        this.setActions(new String[]{"Save", "Cancel"});
    }

    public void deActivate() throws Exception {
    }

    public void doSelect(String selectField, Object value) throws Exception {
        String valueNodeName = String.valueOf(value).trim();
        UIFormInputSetWithAction uiFormInputAction = (UIFormInputSetWithAction)this.getChild(UIFormInputSetWithAction.class);
        ((UIFormStringInput)uiFormInputAction.getChild(UIFormStringInput.class)).setValue((Object)valueNodeName);
        ((UIPopupContainer)this.getAncestorOfType(UIPopupContainer.class)).removeChildById(POPUP_PATH);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SaveActionListener
    extends EventListener<UISelectRestorePath> {
        public void execute(Event<UISelectRestorePath> event) throws Exception {
            UISelectRestorePath uiSelectRestorePath = (UISelectRestorePath)((Object)event.getSource());
            UIJCRExplorer uiExplorer = (UIJCRExplorer)uiSelectRestorePath.getAncestorOfType(UIJCRExplorer.class);
            UIApplication uiApp = (UIApplication)uiSelectRestorePath.getAncestorOfType(UIApplication.class);
            String fullRestorePath = (String)((UIFormStringInput)((UIFormInputSetWithAction)uiSelectRestorePath.getChild(UIFormInputSetWithAction.class)).getChild(UIFormStringInput.class)).getValue();
            int colonIndex = fullRestorePath.indexOf(58);
            if (colonIndex == -1) {
                return;
            }
            String restoreWorkspace = fullRestorePath.substring(0, colonIndex);
            String restorePath = fullRestorePath.substring(colonIndex + 1);
            Node trashNode = (Node)uiSelectRestorePath.getTrashHomeNode().getSession().getItem(uiSelectRestorePath.getSrcPath());
            trashNode.setProperty("exo:restoreWorkspace", restoreWorkspace);
            trashNode.setProperty("exo:restorePath", restorePath + (restorePath.endsWith("/") ? "" : Character.valueOf('/')) + trashNode.getName());
            TrashService trashService = (TrashService)uiSelectRestorePath.getApplicationComponent(TrashService.class);
            try {
                trashService.restoreFromTrash(uiSelectRestorePath.getTrashHomeNode(), uiSelectRestorePath.getSrcPath(), uiExplorer.getSessionProvider());
                UIPopupContainer uiPopupContainer = (UIPopupContainer)uiExplorer.getChild(UIPopupContainer.class);
                uiPopupContainer.removeChild(UISelectRestorePath.class);
                uiExplorer.updateAjax(event);
            }
            catch (PathNotFoundException e) {
                LOG.error((Object)("Path not found! Maybe, it was removed or path changed, can't restore node :" + trashNode.getPath()));
                JCRExceptionManager.process((UIApplication)uiApp, (Exception)((Object)e));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
            }
            catch (LockException e) {
                LOG.error((Object)("node is locked, can't restore node :" + trashNode.getPath()));
                JCRExceptionManager.process((UIApplication)uiApp, (Exception)((Object)e));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
            }
            catch (VersionException e) {
                LOG.error((Object)("node is checked in, can't restore node:" + trashNode.getPath()));
                JCRExceptionManager.process((UIApplication)uiApp, (Exception)((Object)e));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
            }
            catch (AccessDeniedException e) {
                LOG.error((Object)("access denied, can't restore of node:" + trashNode.getPath()));
                JCRExceptionManager.process((UIApplication)uiApp, (Exception)((Object)e));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
            }
            catch (ConstraintViolationException e) {
                LOG.error((Object)("access denied, can't restore of node:" + trashNode.getPath()));
                JCRExceptionManager.process((UIApplication)uiApp, (Exception)((Object)e));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
            }
            catch (Exception e) {
                LOG.error((Object)"an unexpected error occurs", (Throwable)e);
                JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AddActionListener
    extends EventListener<UISelectRestorePath> {
        public void execute(Event<UISelectRestorePath> event) throws Exception {
            UISelectRestorePath uiSelectRestorePath = (UISelectRestorePath)((Object)event.getSource());
            UIPopupContainer uiPopupContainer = (UIPopupContainer)uiSelectRestorePath.getAncestorOfType(UIPopupContainer.class);
            UIJCRExplorer uiExplorer = (UIJCRExplorer)uiSelectRestorePath.getAncestorOfType(UIJCRExplorer.class);
            String workspaceName = uiExplorer.getCurrentWorkspace();
            UIPopupWindow uiPopupWindow = this.initPopup(uiPopupContainer, UISelectRestorePath.POPUP_PATH);
            UIOneNodePathSelector uiNodePathSelector = (UIOneNodePathSelector)uiPopupContainer.createUIComponent(UIOneNodePathSelector.class, null, null);
            uiNodePathSelector.setIsDisable(workspaceName, false);
            uiNodePathSelector.setShowRootPathSelect(true);
            uiNodePathSelector.setRootNodeLocation(uiExplorer.getRepositoryName(), workspaceName, "/");
            uiNodePathSelector.setAcceptedNodeTypesInPathPanel(new String[]{"nt:unstructured", "nt:folder"});
            uiNodePathSelector.setAcceptedNodeTypesInTree(new String[]{"nt:unstructured", "nt:folder"});
            uiNodePathSelector.setExceptedNodeTypesInPathPanel(new String[]{"exo:trashFolder"});
            uiNodePathSelector.setExceptedNodeTypesInTree(new String[]{"exo:trashFolder"});
            if (SessionProviderFactory.isAnonim()) {
                uiNodePathSelector.init(SessionProviderFactory.createAnonimProvider());
            } else if (workspaceName.equals(this.getSystemWorkspaceName(uiExplorer))) {
                uiNodePathSelector.init(SessionProviderFactory.createSystemProvider());
            } else {
                uiNodePathSelector.init(SessionProviderFactory.createSessionProvider());
            }
            String param = "returnField=PathNode";
            uiNodePathSelector.setSourceComponent((UIComponent)uiSelectRestorePath, new String[]{param});
            uiPopupWindow.setUIComponent((UIComponent)uiNodePathSelector);
            uiPopupWindow.setShow(true);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiPopupContainer);
        }

        private String getSystemWorkspaceName(UIJCRExplorer uiExplorer) throws RepositoryException, RepositoryConfigurationException {
            RepositoryService repositoryService = (RepositoryService)uiExplorer.getApplicationComponent(RepositoryService.class);
            ManageableRepository manageableRepository = repositoryService.getCurrentRepository();
            return manageableRepository.getConfiguration().getSystemWorkspaceName();
        }

        private UIPopupWindow initPopup(UIPopupContainer uiPopupContainer, String id) throws Exception {
            UIPopupWindow uiPopup = (UIPopupWindow)uiPopupContainer.getChildById(id);
            if (uiPopup == null) {
                uiPopup = (UIPopupWindow)uiPopupContainer.addChild(UIPopupWindow.class, null, id);
            }
            uiPopup.setWindowSize(700, 350);
            uiPopup.setShow(false);
            uiPopup.setResizable(true);
            return uiPopup;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CancelActionListener
    extends EventListener<UISelectRestorePath> {
        public void execute(Event<UISelectRestorePath> event) throws Exception {
            UIJCRExplorer uiExplorer = (UIJCRExplorer)((UISelectRestorePath)((Object)event.getSource())).getAncestorOfType(UIJCRExplorer.class);
            uiExplorer.cancelAction();
        }
    }
}

