/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.versions;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.PropertyDefinition;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.ecm.webui.component.explorer.versions.UIVersionInfo;
import org.exoplatform.portal.webui.util.SessionProviderFactory;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.core.nodetype.ExtendedNodeTypeManager;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.form.UIForm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/groovy/webui/component/explorer/versions/UINodeProperty.gtmpl")
public class UINodeProperty
extends UIForm {
    public List<Property> getVersionedNodeProperties() throws Exception {
        RepositoryService repositoryService = (RepositoryService)PortalContainer.getComponent(RepositoryService.class);
        ArrayList<Property> list = new ArrayList<Property>();
        ExtendedNodeTypeManager nodeTypeManager = repositoryService.getCurrentRepository().getNodeTypeManager();
        NodeType jcrFrozenNode = nodeTypeManager.getNodeType("nt:frozenNode");
        NodeType ntVersion = nodeTypeManager.getNodeType("nt:version");
        NodeType ntVersionHistory = nodeTypeManager.getNodeType("nt:versionHistory");
        NodeType mixVersionable = nodeTypeManager.getNodeType("mix:versionable");
        UIVersionInfo uiVersionInfo = (UIVersionInfo)this.getAncestorOfType(UIVersionInfo.class);
        Node frozenNode = uiVersionInfo.getCurrentVersionNode().getNode("jcr:frozenNode");
        PropertyIterator propertyIter = frozenNode.getProperties();
        while (propertyIter.hasNext()) {
            Property property = propertyIter.nextProperty();
            boolean isDefinition = false;
            for (PropertyDefinition propDef : jcrFrozenNode.getPropertyDefinitions()) {
                if (!propDef.getName().equals(property.getName())) continue;
                isDefinition = true;
            }
            for (PropertyDefinition propDef : ntVersion.getPropertyDefinitions()) {
                if (!propDef.getName().equals(property.getName())) continue;
                isDefinition = true;
            }
            for (PropertyDefinition propDef : ntVersionHistory.getPropertyDefinitions()) {
                if (!propDef.getName().equals(property.getName())) continue;
                isDefinition = true;
            }
            for (PropertyDefinition propDef : mixVersionable.getPropertyDefinitions()) {
                if (!propDef.getName().equals(property.getName())) continue;
                isDefinition = true;
            }
            if (isDefinition) continue;
            list.add(property);
        }
        return list;
    }

    public String getPropertyValue(Property property) throws Exception {
        switch (property.getType()) {
            case 2: {
                return Integer.toString(2);
            }
            case 6: {
                return Boolean.toString(property.getValue().getBoolean());
            }
            case 5: {
                return property.getValue().getDate().getTime().toString();
            }
            case 4: {
                return Double.toString(property.getValue().getDouble());
            }
            case 3: {
                return Long.toString(property.getValue().getLong());
            }
            case 7: {
                return property.getValue().getString();
            }
            case 1: {
                return property.getValue().getString();
            }
            case 9: {
                if (property.getName().equals("exo:category") || property.getName().equals("exo:relation")) {
                    Session session = this.getSystemSession();
                    Node referenceNode = session.getNodeByUUID(property.getValue().getString());
                    String path = referenceNode.getPath();
                    return path;
                }
                return property.getValue().getString();
            }
        }
        return null;
    }

    public List<String> getPropertyMultiValues(Property property) throws Exception {
        String propName = property.getName();
        if (propName.equals("exo:category")) {
            return this.getCategoriesValues(property);
        }
        if (propName.equals("exo:relation")) {
            return this.getRelationValues(property);
        }
        ArrayList<String> values = new ArrayList<String>();
        for (Value value : property.getValues()) {
            values.add(value.getString());
        }
        return values;
    }

    public boolean isMultiValue(Property prop) throws Exception {
        PropertyDefinition propDef = prop.getDefinition();
        return propDef.isMultiple();
    }

    private List<String> getReferenceValues(Property property) throws Exception {
        Value[] values;
        Session session = this.getSystemSession();
        ArrayList<String> pathList = new ArrayList<String>();
        for (Value value : values = property.getValues()) {
            Node referenceNode = session.getNodeByUUID(value.getString());
            pathList.add(referenceNode.getPath());
        }
        return pathList;
    }

    private List<String> getRelationValues(Property relationProp) throws Exception {
        return this.getReferenceValues(relationProp);
    }

    private List<String> getCategoriesValues(Property categoryProp) throws Exception {
        return this.getReferenceValues(categoryProp);
    }

    private Session getSystemSession() throws Exception {
        ManageableRepository manageableRepository = ((RepositoryService)this.getApplicationComponent(RepositoryService.class)).getCurrentRepository();
        String systemWorksapce = manageableRepository.getConfiguration().getDefaultWorkspaceName();
        Session session = SessionProviderFactory.createSystemProvider().getSession(systemWorksapce, manageableRepository);
        return session;
    }
}

