/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.core;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeLocation {
    private static Log log = ExoLogger.getLogger((String)"wcm:NodeLocation");
    private String repository;
    private String workspace;
    private String path;
    private String uuid;
    private boolean isSystemSession;

    public NodeLocation() {
    }

    public NodeLocation(String repository, String workspace, String path, String uuid, boolean isSystem) {
        this.repository = repository;
        this.workspace = workspace;
        this.path = path;
        this.uuid = uuid;
        this.isSystemSession = isSystem;
    }

    public NodeLocation(String repository, String workspace, String path, String uuid) {
        this(repository, workspace, path, uuid, false);
    }

    public NodeLocation(String repository, String workspace, String path) {
        this(repository, workspace, path, null, false);
    }

    public String getRepository() {
        return this.repository;
    }

    public void setRepository(String repository) {
        this.repository = repository;
    }

    public String getWorkspace() {
        return this.workspace;
    }

    public void setWorkspace(String workspace) {
        this.workspace = workspace;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setUUID(String uuid) {
        this.uuid = uuid;
    }

    public String getUUID() {
        return this.uuid;
    }

    public void setSystemSession(boolean value) {
        this.isSystemSession = value;
    }

    public boolean isSystemSession() {
        return this.isSystemSession;
    }

    @Deprecated
    public static final NodeLocation parse(String exp) {
        String[] temp = exp.split(":");
        if (temp.length == 3 && temp[2].indexOf("/") == 0) {
            return new NodeLocation(temp[0], temp[1], temp[2]);
        }
        throw new IllegalArgumentException("Invalid expression: " + exp + ". An valid expression has pattern repository:workspace:path");
    }

    @Deprecated
    public static final NodeLocation make(Node node) {
        try {
            Session session = node.getSession();
            String repository = ((ManageableRepository)session.getRepository()).getConfiguration().getName();
            String workspace = session.getWorkspace().getName();
            String path = node.getPath();
            return new NodeLocation(repository, workspace, path);
        }
        catch (RepositoryException e) {
            log.error((Object)"make() failed because of ", (Throwable)e);
            return null;
        }
    }

    public static final NodeLocation getNodeLocationByExpression(String exp) {
        String[] temp = exp.split(":");
        if (temp.length >= 3 && temp[2].indexOf("/") == 0) {
            String repository = temp[0];
            String workspace = temp[1];
            String nodepath = exp.substring(repository.length() + workspace.length() + 2);
            return new NodeLocation(repository, workspace, nodepath);
        }
        throw new IllegalArgumentException("Invalid expression: " + exp + ". An valid expression has pattern repository:workspace:path");
    }

    public static final NodeLocation getNodeLocationByNode(Node node) {
        Session session = null;
        try {
            session = node.getSession();
            String repository = ((ManageableRepository)session.getRepository()).getConfiguration().getName();
            String workspace = session.getWorkspace().getName();
            String path = node.getPath();
            String uuid = null;
            try {
                uuid = node.getUUID();
            }
            catch (Exception e) {
                // empty catch block
            }
            return new NodeLocation(repository, workspace, path, uuid);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static final Node getNodeByLocation(NodeLocation nodeLocation) {
        Session session = null;
        try {
            ManageableRepository repository = WCMCoreUtils.getRepository();
            session = WCMCoreUtils.getSystemSessionProvider().getSession(nodeLocation.getWorkspace(), repository);
            if (nodeLocation.getUUID() != null) {
                return session.getNodeByUUID(nodeLocation.getUUID());
            }
            Node node = (Node)session.getItem(nodeLocation.getPath());
            return node;
        }
        catch (PathNotFoundException pne) {
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static final List getNodeListByLocationList(List locationList) {
        ArrayList<Object> ret = new ArrayList<Object>();
        try {
            ManageableRepository repository = WCMCoreUtils.getRepository(null);
            SessionProvider systemSessionProvider = WCMCoreUtils.getSystemSessionProvider();
            SessionProvider sessionProvider = WCMCoreUtils.getUserSessionProvider();
            String systemWorkspace = repository.getConfiguration().getSystemWorkspaceName();
            Session session = null;
            for (Object obj : locationList) {
                if (obj instanceof NodeLocation) {
                    Node node = null;
                    try {
                        NodeLocation location = (NodeLocation)obj;
                        session = systemWorkspace.equals(location.getWorkspace()) ? systemSessionProvider.getSession(location.getWorkspace(), repository) : sessionProvider.getSession(location.getWorkspace(), repository);
                        node = location.getUUID() != null ? session.getNodeByUUID(location.getUUID()) : (Node)session.getItem(location.getPath());
                        ret.add(node);
                    }
                    catch (Exception e) {}
                    continue;
                }
                ret.add(obj);
            }
        }
        catch (Exception e) {
            return ret;
        }
        return ret;
    }

    public static final List getLocationsByNodeList(List nodeList) {
        ArrayList<NodeLocation> ret = new ArrayList<NodeLocation>();
        for (Object obj : nodeList) {
            if (obj instanceof Node) {
                NodeLocation location = NodeLocation.getNodeLocationByNode((Node)obj);
                if (location == null) continue;
                ret.add(location);
                continue;
            }
            ret.add((NodeLocation)obj);
        }
        return ret;
    }

    public static final List<NodeLocation> getLocationsByIterator(NodeIterator nodeIterator) {
        ArrayList<NodeLocation> ret = new ArrayList<NodeLocation>();
        while (nodeIterator.hasNext()) {
            NodeLocation location = NodeLocation.getNodeLocationByNode(nodeIterator.nextNode());
            if (location == null) continue;
            ret.add(location);
        }
        return ret;
    }

    public static final Node getNodeByExpression(String expression) {
        return NodeLocation.getNodeByLocation(NodeLocation.parse(expression));
    }

    public static final String getExpressionByNode(Node node) {
        NodeLocation location = NodeLocation.getNodeLocationByNode(node);
        return NodeLocation.mergeString(location.getRepository(), location.getWorkspace(), location.getPath());
    }

    public static final String getExpressionByNodeLocation(NodeLocation location) {
        return NodeLocation.mergeString(location.getRepository(), location.getWorkspace(), location.getPath());
    }

    public String toString() {
        return NodeLocation.mergeString(this.repository, this.workspace, this.path);
    }

    private static String mergeString(String repository, String workspace, String path) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(repository);
        buffer.append(":");
        buffer.append(workspace);
        buffer.append(":");
        buffer.append(path);
        return buffer.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof NodeLocation)) {
            return false;
        }
        NodeLocation location2 = (NodeLocation)obj;
        return this.repository.equals(location2.getRepository()) && this.getWorkspace().equals(location2.getWorkspace()) && (this.getPath().equals(location2.getPath()) || this.getUUID().equals(location2.getUUID()));
    }
}

