/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.popup.actions;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import javax.jcr.AccessDeniedException;
import javax.jcr.NamespaceException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.version.VersionException;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.exoplatform.ecm.utils.text.Text;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.form.validator.ECMNameValidator;
import org.exoplatform.ecm.webui.form.validator.IllegalDMSCharValidator;
import org.exoplatform.ecm.webui.utils.LockUtil;
import org.exoplatform.services.cms.relations.RelationsService;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.validator.MandatoryValidator;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE)})
public class UIRenameForm
extends UIForm
implements UIPopupComponent {
    public static final String FIELD_NAME = "nameField";
    public static final String FIELD_TITLE = "titleField";
    private static final String RELATION_PROP = "exo:relation";
    private NodeLocation renameNode_;

    public UIRenameForm() throws Exception {
        this.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_TITLE, FIELD_TITLE).addValidator(MandatoryValidator.class, new Object[0]).addValidator(IllegalDMSCharValidator.class, new Object[0]));
        this.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_NAME, FIELD_NAME).addValidator(MandatoryValidator.class, new Object[0]).addValidator(IllegalDMSCharValidator.class, new Object[0]).addValidator(ECMNameValidator.class, new Object[0]));
    }

    public void update(Node renameNode) throws Exception {
        this.renameNode_ = NodeLocation.getNodeLocationByNode((Node)renameNode);
        String renamePath = renameNode.getPath();
        String oldName = Text.unescapeIllegalJcrChars((String)renamePath.substring(renamePath.lastIndexOf("/") + 1, renamePath.length()));
        this.getUIStringInput(FIELD_NAME).setValue((Object)oldName);
        UIFormStringInput titleInput = this.getUIStringInput(FIELD_TITLE);
        if (renameNode.hasProperty("exo:title")) {
            String oldTitle = renameNode.getProperty("exo:title").getString();
            if (oldTitle != null && oldTitle.trim().length() > 0) {
                titleInput.setValue((Object)oldTitle);
            } else {
                titleInput.setValue((Object)oldName);
            }
        } else {
            titleInput.setValue((Object)oldName);
        }
    }

    private void changeLockForChild(String srcPath, Node parentNewNode) throws Exception {
        if (parentNewNode.hasNodes()) {
            NodeIterator newNodeIter = parentNewNode.getNodes();
            String newSRCPath = null;
            while (newNodeIter.hasNext()) {
                Node newChildNode = newNodeIter.nextNode();
                newSRCPath = newChildNode.getPath().replace(parentNewNode.getPath(), srcPath);
                if (newChildNode.isLocked()) {
                    LockUtil.changeLockToken((String)newSRCPath, (Node)newChildNode);
                }
                if (!newChildNode.hasNodes()) continue;
                this.changeLockForChild(newSRCPath, newChildNode);
            }
        }
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CancelActionListener
    extends EventListener<UIRenameForm> {
        public void execute(Event<UIRenameForm> event) throws Exception {
            UIJCRExplorer uiExplorer = (UIJCRExplorer)((UIRenameForm)((Object)event.getSource())).getAncestorOfType(UIJCRExplorer.class);
            uiExplorer.cancelAction();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SaveActionListener
    extends EventListener<UIRenameForm> {
        public void execute(Event<UIRenameForm> event) throws Exception {
            UIRenameForm uiRenameForm = (UIRenameForm)((Object)event.getSource());
            RelationsService relationsService = (RelationsService)uiRenameForm.getApplicationComponent(RelationsService.class);
            UIJCRExplorer uiJCRExplorer = (UIJCRExplorer)uiRenameForm.getAncestorOfType(UIJCRExplorer.class);
            ArrayList<Node> refList = new ArrayList<Node>();
            boolean isReference = false;
            PropertyIterator references = null;
            UIApplication uiApp = (UIApplication)uiRenameForm.getAncestorOfType(UIApplication.class);
            Session nodeSession = null;
            String newName = Text.escapeIllegalJcrChars((String)((String)uiRenameForm.getUIStringInput(UIRenameForm.FIELD_NAME).getValue()).trim());
            Node currentNode = NodeLocation.getNodeByLocation((NodeLocation)uiRenameForm.renameNode_);
            if (currentNode.getName().equals(newName) && this.sameTitle(uiRenameForm, currentNode)) {
                uiJCRExplorer.cancelAction();
                return;
            }
            nodeSession = currentNode.getSession();
            String srcPath = uiRenameForm.renameNode_.getPath();
            if (uiJCRExplorer.nodeIsLocked(currentNode)) {
                uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.node-locked", null, 1));
                uiJCRExplorer.updateAjax(event);
                return;
            }
            try {
                String newTitle;
                boolean changed = false;
                if (!currentNode.getName().equals(newName)) {
                    Node parent;
                    try {
                        references = currentNode.getReferences();
                        isReference = true;
                    }
                    catch (RepositoryException e) {
                        isReference = false;
                    }
                    if (isReference && references != null && references.getSize() > 0L) {
                        while (references.hasNext()) {
                            Property pro = references.nextProperty();
                            Node refNode = pro.getParent();
                            if (!refNode.hasProperty(UIRenameForm.RELATION_PROP)) continue;
                            refList.add(refNode);
                            relationsService.removeRelation(refNode, uiRenameForm.renameNode_.getPath());
                            refNode.save();
                        }
                    }
                    String destPath = (parent = currentNode.getParent()).getPath().equals("/") ? "/" + newName : parent.getPath() + "/" + newName;
                    uiJCRExplorer.addLockToken(parent);
                    nodeSession.getWorkspace().move(srcPath, destPath);
                    String currentPath = uiJCRExplorer.getCurrentPath();
                    if (srcPath.equals(uiJCRExplorer.getCurrentPath())) {
                        uiJCRExplorer.setCurrentPath(destPath);
                    } else if (currentPath.startsWith(srcPath)) {
                        uiJCRExplorer.setCurrentPath(destPath + currentPath.substring(currentPath.lastIndexOf("/")));
                    }
                    nodeSession.save();
                    for (int i = 0; i < refList.size(); ++i) {
                        Node addRef = (Node)refList.get(i);
                        relationsService.addRelation(addRef, destPath, nodeSession.getWorkspace().getName());
                        addRef.save();
                    }
                    Node destNode = (Node)nodeSession.getItem(destPath);
                    if (destNode.isLocked()) {
                        LockUtil.changeLockToken((Node)currentNode, (Node)destNode);
                    }
                    uiRenameForm.changeLockForChild(srcPath, destNode);
                    if (destNode.canAddMixin("exo:modify")) {
                        destNode.addMixin("exo:modify");
                    }
                    destNode.setProperty("exo:lastModifier", nodeSession.getUserID());
                    currentNode = destNode;
                    changed = true;
                }
                if (!this.sameTitle(uiRenameForm, currentNode) && (newTitle = (String)uiRenameForm.getUIStringInput(UIRenameForm.FIELD_TITLE).getValue()).length() > 0) {
                    if (!currentNode.hasProperty("exo:title")) {
                        currentNode.addMixin("exo:rss-enable");
                    }
                    currentNode.setProperty("exo:title", newTitle);
                    changed = true;
                }
                nodeSession.save();
                if (changed) {
                    ListenerService listenerService = (ListenerService)uiRenameForm.getApplicationComponent(ListenerService.class);
                    if (currentNode.isNodeType("exo:datetime")) {
                        currentNode.setProperty("exo:dateModified", (Calendar)new GregorianCalendar());
                    }
                    listenerService.broadcast("CmsService.event.postEdit", (Object)this, (Object)currentNode);
                }
                uiJCRExplorer.updateAjax(event);
            }
            catch (AccessDeniedException ace) {
                if (nodeSession != null) {
                    nodeSession.refresh(false);
                }
                uiJCRExplorer.refreshExplorer();
                uiJCRExplorer.cancelAction();
                Object[] args = new Object[]{currentNode.getName()};
                uiApp.addMessage(new ApplicationMessage("UIRenameForm.msg.rename-denied", args, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiRenameForm);
            }
            catch (VersionException ve) {
                if (nodeSession != null) {
                    nodeSession.refresh(false);
                }
                uiJCRExplorer.refreshExplorer();
                uiJCRExplorer.cancelAction();
                uiApp.addMessage(new ApplicationMessage("UIRenameForm.msg.version-exception", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiRenameForm);
            }
            catch (ConstraintViolationException cons) {
                if (nodeSession != null) {
                    nodeSession.refresh(false);
                }
                uiJCRExplorer.refreshExplorer();
                Object[] args = new Object[]{currentNode.getPrimaryNodeType().getName()};
                uiApp.addMessage(new ApplicationMessage("UIRenameForm.msg.constraintViolation-exception", args, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiRenameForm);
            }
            catch (LockException lockex) {
                uiJCRExplorer.cancelAction();
                Object[] agrs = new Object[]{currentNode.getPrimaryNodeType().getName()};
                uiApp.addMessage(new ApplicationMessage("UIRenameForm.msg.lock-exception", agrs, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiRenameForm);
            }
            catch (Exception e) {
                if (ExceptionUtils.getRootCause((Throwable)e) instanceof NamespaceException) {
                    Object[] agrs = new Object[]{newName.substring(0, newName.indexOf(":"))};
                    uiApp.addMessage(new ApplicationMessage("UIRenameForm.msg.unknown-prefix", agrs, 1));
                } else {
                    Object[] agrs = new Object[]{currentNode.getName()};
                    uiApp.addMessage(new ApplicationMessage("UIRenameForm.msg.rename-error", agrs, 1));
                }
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiRenameForm);
            }
        }

        private boolean sameTitle(UIRenameForm uiRenameForm, Node node) throws Exception {
            String newTitle = (String)uiRenameForm.getUIStringInput(UIRenameForm.FIELD_TITLE).getValue();
            if (!node.hasProperty("exo:title")) {
                return newTitle == null || newTitle.length() == 0;
            }
            return node.getProperty("exo:title").getString().equals(newTitle);
        }
    }
}

