/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.mop.core.util;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;

public class Tools {
    public static <N> List<N> list(Iterator<N> iterable) {
        ArrayList<N> set = new ArrayList<N>();
        while (iterable.hasNext()) {
            set.add(iterable.next());
        }
        return set;
    }

    public static <N> Set<N> set(Iterable<N> iterable) {
        HashSet<N> set = new HashSet<N>();
        for (N n : iterable) {
            set.add(n);
        }
        return set;
    }

    public static <N> Set<N> set(Iterator<N> iterator) {
        HashSet<N> set = new HashSet<N>();
        while (iterator.hasNext()) {
            set.add(iterator.next());
        }
        return set;
    }

    public static <N> Set<N> set() {
        return new HashSet();
    }

    public static <N> Set<N> set(N object) {
        HashSet<N> set = new HashSet<N>();
        set.add(object);
        return set;
    }

    public static <N> Set<N> set(N ... objects) throws NullPointerException {
        if (objects == null) {
            throw new NullPointerException();
        }
        HashSet<N> set = new HashSet<N>();
        for (N object : objects) {
            set.add(object);
        }
        return set;
    }

    public static int max(int value, int ... values) {
        int max = value;
        for (int v : values) {
            if (v <= max) continue;
            max = v;
        }
        return max;
    }

    public static <E> Iterator<E> iterator(final Iterator<? extends E> ... iterators) {
        return new Iterator<E>(){
            int index = 0;

            @Override
            public boolean hasNext() {
                while (this.index < iterators.length) {
                    if (iterators[this.index].hasNext()) {
                        return true;
                    }
                    ++this.index;
                }
                return false;
            }

            @Override
            public E next() {
                while (this.index < iterators.length) {
                    if (iterators[this.index].hasNext()) {
                        return iterators[this.index].next();
                    }
                    ++this.index;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static Type resolve(Type implementation, Class<?> type, int parameterIndex) {
        if (implementation == null) {
            throw new NullPointerException();
        }
        if (implementation == type) {
            TypeVariable<Class<?>>[] tp = type.getTypeParameters();
            if (parameterIndex < tp.length) {
                return tp[parameterIndex];
            }
            throw new IllegalArgumentException();
        }
        if (implementation instanceof Class) {
            Class c = (Class)implementation;
            Type gsc = c.getGenericSuperclass();
            Type resolved = null;
            if (gsc == null || (resolved = Tools.resolve(gsc, type, parameterIndex)) == null) {
                // empty if block
            }
            return resolved;
        }
        if (implementation instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)implementation;
            Type[] typeArgs = pt.getActualTypeArguments();
            Type rawType = pt.getRawType();
            if (rawType == type) {
                return typeArgs[parameterIndex];
            }
            if (rawType instanceof Class) {
                Class classRawType = (Class)rawType;
                Type resolved = Tools.resolve(classRawType, type, parameterIndex);
                if (resolved == null) {
                    return null;
                }
                if (resolved instanceof TypeVariable) {
                    TypeVariable resolvedTV = (TypeVariable)resolved;
                    TypeVariable<Class<T>>[] a = classRawType.getTypeParameters();
                    for (int i = 0; i < a.length; ++i) {
                        if (!a[i].equals(resolvedTV)) continue;
                        return Tools.resolve(implementation, classRawType, i);
                    }
                    throw new AssertionError();
                }
                throw new UnsupportedOperationException("Cannot support resolution of " + resolved);
            }
            throw new UnsupportedOperationException();
        }
        throw new UnsupportedOperationException("todo " + implementation + " " + implementation.getClass());
    }
}

