/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.portal;

import java.util.Calendar;
import java.util.GregorianCalendar;
import javax.jcr.Node;
import org.exoplatform.services.jcr.access.PermissionType;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.services.wcm.core.BaseWebSchemaHandler;

public class PortalFolderSchemaHandler
extends BaseWebSchemaHandler {
    public Node getCSSFolder(Node portalFolder) throws Exception {
        return portalFolder.getNode("css");
    }

    public Node getJSFolder(Node portalFolder) throws Exception {
        return portalFolder.getNode("js");
    }

    public Node getMultimediaFolder(Node portalFolder) throws Exception {
        return portalFolder.getNode("medias");
    }

    public Node getImagesFolder(Node portalFolder) throws Exception {
        return portalFolder.getNode("medias/images");
    }

    public Node getVideoFolder(Node portalFolder) throws Exception {
        return portalFolder.getNode("medias/videos");
    }

    public Node getAudioFolder(Node portalFolder) throws Exception {
        return portalFolder.getNode("medias/audio");
    }

    public Node getDocumentStorage(Node portalFolder) throws Exception {
        return portalFolder.getNode("documents");
    }

    public Node getLinkFolder(Node portalFolder) throws Exception {
        return portalFolder.getNode("links");
    }

    public Node getWebContentStorage(Node portalFolder) throws Exception {
        return portalFolder.getNode("web contents");
    }

    protected String getHandlerNodeType() {
        return "exo:portalFolder";
    }

    protected String getParentNodeType() {
        return "nt:unstructured";
    }

    public void onCreateNode(SessionProvider sessionProvider, Node portalFolder) throws Exception {
        GregorianCalendar calendar = new GregorianCalendar();
        if (!portalFolder.hasNode("js")) {
            Node jsFolder = portalFolder.addNode("js", "exo:jsFolder");
            this.addMixin(jsFolder, "exo:owneable");
            this.addMixin(jsFolder, "exo:datetime");
            jsFolder.setProperty("exo:dateCreated", (Calendar)calendar);
        }
        if (!portalFolder.hasNode("css")) {
            Node cssFolder = portalFolder.addNode("css", "exo:cssFolder");
            this.addMixin(cssFolder, "exo:owneable");
            this.addMixin(cssFolder, "exo:datetime");
            cssFolder.setProperty("exo:dateCreated", (Calendar)calendar);
        }
        if (!portalFolder.hasNode("medias")) {
            Node multimedia = portalFolder.addNode("medias", "exo:multimediaFolder");
            this.addMixin(multimedia, "exo:owneable");
            this.addMixin(multimedia, "exo:datetime");
            multimedia.setProperty("exo:dateCreated", (Calendar)calendar);
            Node images = multimedia.addNode("images", "nt:folder");
            this.addMixin(images, "exo:pictureFolder");
            this.addMixin(images, "exo:owneable");
            this.addMixin(images, "exo:datetime");
            images.setProperty("exo:dateCreated", (Calendar)calendar);
            Node video = multimedia.addNode("videos", "nt:folder");
            this.addMixin(video, "exo:videoFolder");
            this.addMixin(video, "exo:owneable");
            this.addMixin(video, "exo:datetime");
            video.setProperty("exo:dateCreated", (Calendar)calendar);
            Node audio = multimedia.addNode("audio", "nt:folder");
            this.addMixin(audio, "exo:musicFolder");
            this.addMixin(audio, "exo:owneable");
            this.addMixin(audio, "exo:datetime");
            audio.setProperty("exo:dateCreated", (Calendar)calendar);
        }
        if (!portalFolder.hasNode("documents")) {
            Node document = portalFolder.addNode("documents", "nt:unstructured");
            this.addMixin(document, "exo:documentFolder");
            this.addMixin(document, "exo:owneable");
            this.addMixin(document, "exo:datetime");
            document.setProperty("exo:dateCreated", (Calendar)calendar);
            document.addMixin("exo:privilegeable");
            ((ExtendedNode)document).setPermission(IdentityConstants.ANY, PermissionType.ALL);
        }
        if (!portalFolder.hasNode("web contents")) {
            Node webContents = portalFolder.addNode("web contents", "exo:webFolder");
            this.addMixin(webContents, "exo:owneable");
            this.addMixin(webContents, "exo:datetime");
            webContents.setProperty("exo:dateCreated", (Calendar)calendar);
            Node themes = webContents.addNode("site artifacts", "exo:themeFolder");
            this.addMixin(themes, "exo:owneable");
            this.addMixin(themes, "exo:datetime");
            themes.setProperty("exo:dateCreated", (Calendar)calendar);
        }
        if (!portalFolder.hasNode("links")) {
            Node links = portalFolder.addNode("links", "exo:linkFolder");
            this.addMixin(links, "exo:owneable");
            this.addMixin(links, "exo:datetime");
            links.setProperty("exo:dateCreated", (Calendar)calendar);
        }
        if (!portalFolder.hasNode("categories")) {
            Node categoryFolder = portalFolder.addNode("categories", "nt:unstructured");
            this.addMixin(categoryFolder, "exo:owneable");
            this.addMixin(categoryFolder, "exo:datetime");
            categoryFolder.setProperty("exo:dateCreated", (Calendar)calendar);
        }
        if (!portalFolder.hasNode("ApplicationData")) {
            Node applicationDataFolder = portalFolder.addNode("ApplicationData", "nt:unstructured");
            this.addMixin(applicationDataFolder, "exo:owneable");
            this.addMixin(applicationDataFolder, "exo:datetime");
            applicationDataFolder.setProperty("exo:dateCreated", (Calendar)calendar);
            Node newsletterApplicationFolder = applicationDataFolder.addNode("NewsletterApplication", "nt:unstructured");
            this.addMixin(newsletterApplicationFolder, "exo:owneable");
            this.addMixin(newsletterApplicationFolder, "exo:datetime");
            newsletterApplicationFolder.setProperty("exo:dateCreated", (Calendar)calendar);
            Node defaultTemplatesFolder = newsletterApplicationFolder.addNode("DefaultTemplates", "nt:unstructured");
            this.addMixin(defaultTemplatesFolder, "exo:owneable");
            this.addMixin(defaultTemplatesFolder, "exo:datetime");
            defaultTemplatesFolder.setProperty("exo:dateCreated", (Calendar)calendar);
            Node newsletterCategoriesFolder = newsletterApplicationFolder.addNode("Categories", "nt:unstructured");
            this.addMixin(newsletterCategoriesFolder, "exo:owneable");
            this.addMixin(newsletterCategoriesFolder, "exo:datetime");
            newsletterCategoriesFolder.setProperty("exo:dateCreated", (Calendar)calendar);
            Node newsletterUserFolder = newsletterApplicationFolder.addNode("Users", "nt:unstructured");
            this.addMixin(newsletterUserFolder, "exo:owneable");
            this.addMixin(newsletterUserFolder, "exo:datetime");
            newsletterUserFolder.setProperty("exo:dateCreated", (Calendar)calendar);
        }
        portalFolder.getSession().save();
    }
}

