/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.extensions.scheduler.impl;

import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.exoplatform.services.ecm.publication.PublicationPlugin;
import org.exoplatform.services.ecm.publication.PublicationService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class ChangeStateCronJobImpl
implements Job {
    private static final Log log = ExoLogger.getLogger(ChangeStateCronJobImpl.class);
    private static final String START_TIME_PROPERTY = "publication:startPublishedDate";
    private static final String END_TIME_PROPERTY = "publication:endPublishedDate";
    private String fromState = null;
    private String toState = null;
    private String predefinedPath = null;
    private String workspace = null;
    private String contentPath = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(JobExecutionContext context) throws JobExecutionException {
        Session session = null;
        try {
            RuntimeMXBean mx = ManagementFactory.getRuntimeMXBean();
            if (mx.getUptime() > 120000L) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Start Execute ChangeStateCronJob");
                }
                if (this.fromState == null) {
                    JobDataMap jdatamap = context.getJobDetail().getJobDataMap();
                    this.fromState = jdatamap.getString("fromState");
                    this.toState = jdatamap.getString("toState");
                    this.predefinedPath = jdatamap.getString("predefinedPath");
                    String[] pathTab = this.predefinedPath.split(":");
                    this.workspace = pathTab[0];
                    this.contentPath = pathTab[1];
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Start Execute ChangeStateCronJob: change the State from " + this.fromState + " to " + this.toState));
                }
                SessionProvider sessionProvider = SessionProvider.createSystemProvider();
                String containerName = WCMCoreUtils.getContainerNameFromJobContext((JobExecutionContext)context);
                RepositoryService repositoryService_ = (RepositoryService)WCMCoreUtils.getService(RepositoryService.class, (String)containerName);
                PublicationService publicationService = (PublicationService)WCMCoreUtils.getService(PublicationService.class, (String)containerName);
                ManageableRepository manageableRepository = repositoryService_.getCurrentRepository();
                if (manageableRepository == null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Repository not found. Ignoring");
                    }
                    return;
                }
                session = sessionProvider.getSession(this.workspace, manageableRepository);
                QueryManager queryManager = session.getWorkspace().getQueryManager();
                String property = null;
                if ("staged".equals(this.fromState) && "published".equals(this.toState)) {
                    property = START_TIME_PROPERTY;
                } else if ("published".equals(this.fromState) && "unpublished".equals(this.toState)) {
                    property = END_TIME_PROPERTY;
                }
                if (property != null) {
                    Query query;
                    QueryResult queryResult;
                    long numberOfItemsToChange;
                    if (this.contentPath != null && !this.contentPath.endsWith("/")) {
                        this.contentPath = this.contentPath + "/";
                    }
                    if ((numberOfItemsToChange = (queryResult = (query = queryManager.createQuery("select * from nt:base where publication:currentState='" + this.fromState + "'" + " and jcr:path like '" + this.contentPath + "%'", "sql")).execute()).getNodes().getSize()) > 0L) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)(numberOfItemsToChange + " '" + this.fromState + "' candidates for state '" + this.toState + "' found in " + this.predefinedPath));
                        }
                        PublicationPlugin publicationPlugin = (PublicationPlugin)publicationService.getPublicationPlugins().get("Authoring publication");
                        HashMap<String, String> context_ = new HashMap<String, String>();
                        context_.put("containerName", containerName);
                        NodeIterator iter = queryResult.getNodes();
                        while (iter.hasNext()) {
                            Node node_ = iter.nextNode();
                            String path = node_.getPath();
                            if (path.startsWith("/jcr:system")) continue;
                            if (node_.hasProperty(property)) {
                                Node liveRevision;
                                String liveRevisionProperty;
                                Date nodeDate;
                                SimpleDateFormat format = new SimpleDateFormat("dd-MM-yyyy - HH:mm");
                                Date now = Calendar.getInstance().getTime();
                                if (now.compareTo(nodeDate = node_.getProperty(property).getDate().getTime()) < 0) continue;
                                if (log.isInfoEnabled()) {
                                    log.info((Object)("'" + this.toState + "' " + node_.getPath() + " (" + property + "=" + format.format(nodeDate) + ")"));
                                }
                                if ("unpublished".equals(this.toState) && node_.hasProperty("publication:liveRevision") && !"".equals(liveRevisionProperty = node_.getProperty("publication:liveRevision").getString()) && (liveRevision = session.getNodeByUUID(liveRevisionProperty)) != null) {
                                    context_.put("Publication.context.currentVersion", liveRevision.getName());
                                }
                                publicationPlugin.changeState(node_, this.toState, context_);
                                continue;
                            }
                            if (!START_TIME_PROPERTY.equals(property)) continue;
                            if (log.isInfoEnabled()) {
                                log.info((Object)("'" + this.toState + "' " + node_.getPath()));
                            }
                            publicationPlugin.changeState(node_, this.toState, context_);
                        }
                    } else if (log.isDebugEnabled()) {
                        log.debug((Object)("no '" + this.fromState + "' content found in " + this.predefinedPath));
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)"End Execute ChangeStateCronJob");
                }
            }
        }
        catch (RepositoryException ex) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Repository not found. Ignoring");
            }
        }
        catch (Exception ex) {
            if (log.isErrorEnabled()) {
                log.error((Object)("error when changing the state of the content : " + ex.getMessage()), (Throwable)ex);
            }
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }
}

