/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.connector.collaboration;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Response;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.dom.DOMSource;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Path(value="/bundle/")
public class ResourceBundleConnector
implements ResourceContainer {
    @GET
    @Path(value="/getBundle/")
    public Response getBundle(@QueryParam(value="key") String multiKey, @QueryParam(value="locale") String locale) {
        try {
            ResourceBundleService resourceBundleService = (ResourceBundleService)WCMCoreUtils.getService(ResourceBundleService.class);
            String[] resourceBundleNames = resourceBundleService.getSharedResourceBundleNames();
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element bundles = document.createElement("bundles");
            bundles.setAttribute("locale", locale);
            String[] keys = multiKey.split(",");
            LinkedHashSet remainingKeys = new LinkedHashSet(keys.length + 1, 1.0f);
            Collections.addAll(remainingKeys, keys);
            block4: for (String resourceBundleName : resourceBundleNames) {
                ResourceBundle resourceBundle = null;
                resourceBundle = locale.indexOf("_") > 0 ? resourceBundleService.getResourceBundle(resourceBundleName, new Locale(locale.substring(0, locale.lastIndexOf("_")), locale.substring(locale.lastIndexOf("_") + 1, locale.length()))) : resourceBundleService.getResourceBundle(resourceBundleName, new Locale(locale));
                Iterator it = remainingKeys.iterator();
                while (it.hasNext()) {
                    String key = (String)it.next();
                    try {
                        String value = resourceBundle.getString(key);
                        Element element = document.createElement(key);
                        element.setAttribute("value", value);
                        bundles.appendChild(element);
                        it.remove();
                        if (!remainingKeys.isEmpty()) continue;
                        break block4;
                    }
                    catch (MissingResourceException e) {
                    }
                }
            }
            document.appendChild(bundles);
            CacheControl cacheControl = new CacheControl();
            cacheControl.setNoCache(true);
            cacheControl.setNoStore(true);
            return Response.ok((Object)new DOMSource(document), (String)"text/xml").cacheControl(cacheControl).build();
        }
        catch (Exception e) {
            return Response.serverError().build();
        }
    }
}

