/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.tree.selectone;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.exoplatform.ecm.webui.selector.UISelectable;
import org.exoplatform.ecm.webui.tree.UIBaseNodeTreeSelector;
import org.exoplatform.ecm.webui.tree.selectone.UIOneNodePathSelector;
import org.exoplatform.ecm.webui.tree.selectone.UIOneTaxonomySelector;
import org.exoplatform.ecm.webui.tree.selectone.UISelectPathPanel;
import org.exoplatform.ecm.webui.tree.selectone.UITreeTaxonomyList;
import org.exoplatform.portal.webui.container.UIContainer;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPageIterator;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfig(template="classpath:groovy/ecm/webui/tree/selectone/UISelectPathPanel.gtmpl", events={@EventConfig(listeners={SelectActionListener.class})})
public class UISelectTaxonomyPanel
extends UISelectPathPanel {
    private UIPageIterator uiPageIterator_ = (UIPageIterator)this.addChild(UIPageIterator.class, null, "UISelectPathIterate");
    private static String TAXONOMY_TREE = "taxonomyTree";
    private String taxonomyTreePath = "";

    public String getTaxonomyTreePath() {
        return this.taxonomyTreePath;
    }

    public void setTaxonomyTreePath(String taxonomyTreePath) {
        this.taxonomyTreePath = taxonomyTreePath;
    }

    public String getPathTaxonomy() throws Exception {
        NodeHierarchyCreator nodeHierarchyCreator = (NodeHierarchyCreator)this.getApplicationComponent(NodeHierarchyCreator.class);
        return nodeHierarchyCreator.getJcrPath("exoTaxoTreesStoragePath");
    }

    public String getPathSystemTaxonomy() throws Exception {
        NodeHierarchyCreator nodeHierarchyCreator = (NodeHierarchyCreator)this.getApplicationComponent(NodeHierarchyCreator.class);
        return nodeHierarchyCreator.getJcrPath("exoTaxonomiesPath");
    }

    public String getDisplayName(Node node) throws RepositoryException {
        return ((UIOneTaxonomySelector)this.getAncestorOfType(UIOneTaxonomySelector.class)).getTaxonomyLabel(node);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SelectActionListener
    extends EventListener<UISelectTaxonomyPanel> {
        public void execute(Event<UISelectTaxonomyPanel> event) throws Exception {
            UIComponent component;
            UIComponent uiComponent;
            UISelectTaxonomyPanel uiSelectPathPanel = (UISelectTaxonomyPanel)((Object)event.getSource());
            UIOneTaxonomySelector uiTaxonomySelector = (UIOneTaxonomySelector)uiSelectPathPanel.getParent();
            UITreeTaxonomyList uiTreeList = (UITreeTaxonomyList)uiTaxonomySelector.getChild(UITreeTaxonomyList.class);
            UIContainer uiTreeSelector = (UIContainer)uiSelectPathPanel.getParent();
            String value = event.getRequestContext().getRequestParameter("objectId");
            String taxoTreeName = (String)uiTreeList.getUIFormSelectBox(TAXONOMY_TREE).getValue();
            Node taxoTreeNode = uiTaxonomySelector.getTaxoTreeNode(taxoTreeName);
            String taxoTreePath = taxoTreeNode.getPath();
            value = value.replace(taxoTreePath, taxoTreeName);
            if (uiTreeSelector instanceof UIOneNodePathSelector && !((UIOneNodePathSelector)uiTreeSelector).isDisable()) {
                value = ((UIOneNodePathSelector)uiTreeSelector).getWorkspaceName() + ":" + value;
            }
            String returnField = ((UIBaseNodeTreeSelector)uiTreeSelector).getReturnFieldName();
            ((UISelectable)((UIBaseNodeTreeSelector)uiTreeSelector).getSourceComponent()).doSelect(returnField, value);
            UIComponent uiOneNodePathSelector = uiSelectPathPanel.getParent();
            if (uiOneNodePathSelector instanceof UIOneNodePathSelector) {
                uiComponent = uiOneNodePathSelector.getParent();
                if (uiComponent instanceof UIPopupWindow) {
                    ((UIPopupWindow)uiComponent).setShow(false);
                    ((UIPopupWindow)uiComponent).setRendered(false);
                    event.getRequestContext().addUIComponentToUpdateByAjax(uiComponent);
                }
                if ((component = ((UIOneNodePathSelector)uiOneNodePathSelector).getSourceComponent().getParent()) != null) {
                    event.getRequestContext().addUIComponentToUpdateByAjax(component);
                    return;
                }
            }
            if (uiOneNodePathSelector instanceof UIOneTaxonomySelector) {
                uiComponent = uiOneNodePathSelector.getParent();
                if (uiComponent instanceof UIPopupWindow) {
                    ((UIPopupWindow)uiComponent).setShow(false);
                    ((UIPopupWindow)uiComponent).setRendered(false);
                    event.getRequestContext().addUIComponentToUpdateByAjax(uiComponent);
                }
                if ((component = ((UIOneTaxonomySelector)uiOneNodePathSelector).getSourceComponent().getParent()) != null) {
                    event.getRequestContext().addUIComponentToUpdateByAjax(component);
                }
            }
        }
    }
}

