/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.vfs.spi.deployer;

import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.helpers.DefaultValidationEventHandler;
import javax.xml.validation.Schema;
import org.jboss.deployers.vfs.spi.deployer.AbstractVFSParsingDeployer;
import org.jboss.deployers.vfs.spi.deployer.SchemaHelper;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.virtual.VFSInputSource;
import org.jboss.virtual.VirtualFile;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JAXBDeployer<T>
extends AbstractVFSParsingDeployer<T> {
    private JAXBContext context;
    private Map<String, Object> properties;
    private Class<?>[] classesToBeBound;
    private String schemaLocation;
    private ValidationEventHandler validationEventHandler = new DefaultValidationEventHandler();

    public JAXBDeployer(Class<T> output) {
        super(output);
        this.classesToBeBound = new Class[]{output};
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public void setClassesToBeBound(Class<?> ... classesToBeBound) {
        this.classesToBeBound = classesToBeBound;
    }

    public void setSchemaLocation(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public void setValidationEventHandler(ValidationEventHandler validationEventHandler) {
        this.validationEventHandler = validationEventHandler;
    }

    public void create() throws Exception {
        this.context = this.createContext();
    }

    protected JAXBContext createContext() throws Exception {
        if (this.properties != null) {
            return JAXBContext.newInstance((Class[])this.classesToBeBound(), this.properties);
        }
        return JAXBContext.newInstance((Class[])this.classesToBeBound());
    }

    protected Class<?>[] classesToBeBound() {
        return this.classesToBeBound;
    }

    public void destroy() {
        this.context = null;
    }

    @Override
    protected T parse(VFSDeploymentUnit unit, VirtualFile file, T root) throws Exception {
        if (file == null) {
            throw new IllegalArgumentException("Null file");
        }
        this.log.debug((Object)("Parsing: " + file.getName()));
        Unmarshaller unmarshaller = this.context.createUnmarshaller();
        unmarshaller.setEventHandler(this.validationEventHandler);
        Schema schema = SchemaHelper.getSchema(this.schemaLocation);
        if (schema != null) {
            unmarshaller.setSchema(schema);
        }
        VFSInputSource source = new VFSInputSource(file);
        Object result = unmarshaller.unmarshal((InputSource)source);
        return this.getOutput().cast(result);
    }
}

