/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.services.binding;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Set;
import org.jboss.services.binding.SystemPropertyBinding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SystemPropertyBinder {
    private final Set<SystemPropertyBinding> bindings;

    public SystemPropertyBinder(Set<SystemPropertyBinding> bindings) {
        this.bindings = bindings;
    }

    public void start() {
        for (SystemPropertyBinding binding : this.bindings) {
            final String property = binding.getProperty();
            final String value = binding.getValue();
            if (System.getSecurityManager() == null) {
                System.setProperty(property, value);
                continue;
            }
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    System.setProperty(property, value);
                    return null;
                }
            });
        }
    }

    public void stop() {
        for (SystemPropertyBinding binding : this.bindings) {
            final String property = binding.getProperty();
            if (System.getSecurityManager() == null) {
                System.clearProperty(property);
                continue;
            }
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    System.clearProperty(property);
                    return null;
                }
            });
        }
    }
}

