/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.servant;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.jacorb.notification.NoTranslationException;
import org.jacorb.notification.OfferManager;
import org.jacorb.notification.SubscriptionManager;
import org.jacorb.notification.engine.TaskProcessor;
import org.jacorb.notification.interfaces.Message;
import org.jacorb.notification.queue.MessageQueueAdapter;
import org.jacorb.notification.queue.RWLockEventQueueDecorator;
import org.jacorb.notification.servant.AbstractProxySupplier;
import org.jacorb.notification.servant.ITypedAdmin;
import org.jacorb.notification.servant.ITypedProxy;
import org.jacorb.notification.servant.TypedProxyPullSupplierImplMBean;
import org.jacorb.notification.util.PropertySet;
import org.jacorb.notification.util.PropertySetAdapter;
import org.jacorb.notification.util.PropertySetListener;
import org.omg.CORBA.Any;
import org.omg.CORBA.BooleanHolder;
import org.omg.CORBA.InterfaceDef;
import org.omg.CORBA.InterfaceDefHelper;
import org.omg.CORBA.InterfaceDefPackage.FullInterfaceDescription;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.NVList;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.OperationDescription;
import org.omg.CORBA.Repository;
import org.omg.CORBA.ServerRequest;
import org.omg.CosEventChannelAdmin.AlreadyConnected;
import org.omg.CosEventComm.Disconnected;
import org.omg.CosEventComm.PullConsumer;
import org.omg.CosNotification.EventTypeHelper;
import org.omg.CosNotification.Property;
import org.omg.CosNotifyChannelAdmin.ConsumerAdmin;
import org.omg.CosNotifyChannelAdmin.ProxyType;
import org.omg.CosTypedNotifyChannelAdmin.TypedProxyPullSupplierOperations;
import org.omg.CosTypedNotifyChannelAdmin.TypedProxyPullSupplierPOATie;
import org.omg.DynamicAny.DynAny;
import org.omg.DynamicAny.DynAnyFactory;
import org.omg.DynamicAny.DynAnyFactoryPackage.InconsistentTypeCode;
import org.omg.PortableServer.DynamicImplementation;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.Servant;

public class TypedProxyPullSupplierImpl
extends AbstractProxySupplier
implements TypedProxyPullSupplierOperations,
ITypedProxy,
TypedProxyPullSupplierImplMBean {
    private final Any trueAny_;
    private final Any falseAny_;
    private final DynAnyFactory dynAnyFactory_;
    private final String supportedInterface_;
    private PullConsumer pullConsumer_;
    private TypedProxyPullSupplier typedProxyPullSupplierServant_;
    private Object typedProxyPullSupplier_;
    private final Map messageQueueMap_;
    private final Map invalidResponses_;
    private final Repository repository_;
    private PropertySetAdapter reconfigureEventQueues_ = new PropertySetAdapter(){

        public void actionPropertySetChanged(PropertySet propertySet) {
            TypedProxyPullSupplierImpl.this.configureEventQueue();
        }
    };

    private final NVList prepareResponse(Message message) {
        try {
            Property[] propertyArray = message.toTypedEvent();
            NVList nVList = this.getORB().create_list(propertyArray.length - 1);
            for (int i = 1; i < propertyArray.length; ++i) {
                nVList.add_value(propertyArray[i].name, propertyArray[i].value, 2);
            }
            return nVList;
        }
        catch (NoTranslationException noTranslationException) {
            throw new RuntimeException();
        }
    }

    public TypedProxyPullSupplierImpl(ITypedAdmin iTypedAdmin, ConsumerAdmin consumerAdmin, ORB oRB, POA pOA, Configuration configuration, TaskProcessor taskProcessor, OfferManager offerManager, SubscriptionManager subscriptionManager, DynAnyFactory dynAnyFactory, Repository repository) throws ConfigurationException {
        super(iTypedAdmin, oRB, pOA, configuration, taskProcessor, offerManager, subscriptionManager, consumerAdmin);
        this.trueAny_ = oRB.create_any();
        this.falseAny_ = oRB.create_any();
        this.trueAny_.insert_boolean(true);
        this.falseAny_.insert_boolean(false);
        this.supportedInterface_ = iTypedAdmin.getSupportedInterface();
        this.dynAnyFactory_ = dynAnyFactory;
        this.repository_ = repository;
        this.qosSettings_.addPropertySetListener(new String[]{"OrderPolicy", "DiscardPolicy"}, (PropertySetListener)this.reconfigureEventQueues_);
        try {
            FullInterfaceDescription fullInterfaceDescription = this.getInterfaceDescription();
            this.validateInterface(fullInterfaceDescription);
            this.messageQueueMap_ = Collections.unmodifiableMap(this.newMessageQueueMap(fullInterfaceDescription));
            this.invalidResponses_ = Collections.unmodifiableMap(this.newInvalidResponseMap(fullInterfaceDescription));
        }
        catch (InconsistentTypeCode inconsistentTypeCode) {
            throw new RuntimeException();
        }
    }

    private void ensureMethodOnlyUsesOutParams(OperationDescription operationDescription) throws IllegalArgumentException {
        int n = operationDescription.parameters.length;
        for (int i = 0; i < n; ++i) {
            switch (operationDescription.parameters[i].mode.value()) {
                case 0: 
                case 2: {
                    throw new IllegalArgumentException("only OUT params allowed");
                }
            }
        }
    }

    private void prepareInvalidResponse(Map map, OperationDescription operationDescription) throws InconsistentTypeCode {
        NVList nVList = this.getORB().create_list(operationDescription.parameters.length);
        for (int i = 0; i < operationDescription.parameters.length; ++i) {
            DynAny dynAny = this.dynAnyFactory_.create_dyn_any_from_type_code(operationDescription.parameters[i].type);
            nVList.add_value(operationDescription.parameters[i].name, dynAny.to_any(), 2);
        }
        map.put(operationDescription.name, nVList);
    }

    private final Map newMessageQueueMap(FullInterfaceDescription fullInterfaceDescription) {
        HashMap<String, RWLockEventQueueDecorator> hashMap = new HashMap<String, RWLockEventQueueDecorator>();
        for (int i = 0; i < fullInterfaceDescription.operations.length; ++i) {
            if (fullInterfaceDescription.operations[i].name.startsWith("try_")) continue;
            this.logger_.debug("Create Queue for Operation: " + fullInterfaceDescription.operations[i].name);
            MessageQueueAdapter messageQueueAdapter = this.getMessageQueueFactory().newMessageQueue(this.qosSettings_);
            hashMap.put(fullInterfaceDescription.operations[i].name, new RWLockEventQueueDecorator(messageQueueAdapter));
        }
        return hashMap;
    }

    private final Map newInvalidResponseMap(FullInterfaceDescription fullInterfaceDescription) throws InconsistentTypeCode {
        HashMap hashMap = new HashMap();
        for (int i = 0; i < fullInterfaceDescription.operations.length; ++i) {
            if (fullInterfaceDescription.operations[i].name.startsWith("try_")) continue;
            this.prepareInvalidResponse(hashMap, fullInterfaceDescription.operations[i]);
        }
        return hashMap;
    }

    private final void validateInterface(FullInterfaceDescription fullInterfaceDescription) {
        for (int i = 0; i < fullInterfaceDescription.operations.length; ++i) {
            this.ensureMethodOnlyUsesOutParams(fullInterfaceDescription.operations[i]);
        }
    }

    private FullInterfaceDescription getInterfaceDescription() {
        InterfaceDef interfaceDef = InterfaceDefHelper.narrow(this.repository_.lookup_id(this.supportedInterface_));
        return interfaceDef.describe_interface();
    }

    private final void configureEventQueue() {
        try {
            Iterator iterator = this.messageQueueMap_.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                RWLockEventQueueDecorator rWLockEventQueueDecorator = (RWLockEventQueueDecorator)this.messageQueueMap_.get(string);
                MessageQueueAdapter messageQueueAdapter = this.getMessageQueueFactory().newMessageQueue(this.qosSettings_);
                rWLockEventQueueDecorator.replaceDelegate(messageQueueAdapter);
            }
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException.toString());
        }
    }

    public int getPendingMessagesCount() {
        try {
            Iterator iterator = this.messageQueueMap_.keySet().iterator();
            int n = 0;
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                RWLockEventQueueDecorator rWLockEventQueueDecorator = (RWLockEventQueueDecorator)this.messageQueueMap_.get(string);
                n += rWLockEventQueueDecorator.getPendingMessagesCount();
            }
            return n;
        }
        catch (InterruptedException interruptedException) {
            return -1;
        }
    }

    public Any pull() throws Disconnected {
        throw new NO_IMPLEMENT();
    }

    public Any try_pull(BooleanHolder booleanHolder) throws Disconnected {
        throw new NO_IMPLEMENT();
    }

    public void disconnect_pull_supplier() {
        this.destroy();
    }

    public void connect_typed_pull_consumer(PullConsumer pullConsumer) throws AlreadyConnected {
        this.checkIsNotConnected();
        this.connectClient(pullConsumer);
        this.pullConsumer_ = pullConsumer;
    }

    public Object get_typed_supplier() {
        if (this.typedProxyPullSupplierServant_ == null) {
            this.typedProxyPullSupplierServant_ = new TypedProxyPullSupplier();
            this.typedProxyPullSupplier_ = this.typedProxyPullSupplierServant_._this_object(this.getORB());
        }
        return this.typedProxyPullSupplier_;
    }

    public ProxyType MyType() {
        return ProxyType.PULL_TYPED;
    }

    public Servant newServant() {
        return new TypedProxyPullSupplierPOATie(this);
    }

    public void queueMessage(Message message) {
        try {
            String string;
            Property[] propertyArray = message.toTypedEvent();
            if ("operation".equals(propertyArray[0].name)) {
                string = propertyArray[0].value.extract_string();
            } else if ("event_type".equals(propertyArray[0].name)) {
                string = EventTypeHelper.extract((Any)propertyArray[0].value).type_name;
            } else {
                throw new IllegalArgumentException();
            }
            int n = string.lastIndexOf("::");
            String string2 = string.substring(n + 2);
            Message message2 = (Message)message.clone();
            try {
                ((MessageQueueAdapter)this.messageQueueMap_.get(string2)).enqeue(message2);
            }
            catch (InterruptedException interruptedException) {
                message2.dispose();
            }
        }
        catch (NoTranslationException noTranslationException) {
            // empty catch block
        }
    }

    public void deliverPendingData() {
    }

    public void disconnectClient() {
        this.pullConsumer_.disconnect_pull_consumer();
        this.pullConsumer_ = null;
    }

    protected long getCost() {
        return 0L;
    }

    public String getSupportedInterface() {
        return this.supportedInterface_;
    }

    private class TypedProxyPullSupplier
    extends DynamicImplementation {
        private final String[] supportedInterfaces_;

        private TypedProxyPullSupplier() {
            this.supportedInterfaces_ = new String[]{TypedProxyPullSupplierImpl.this.supportedInterface_};
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void invoke(ServerRequest serverRequest) {
            String string = serverRequest.operation();
            boolean bl = false;
            if (string.startsWith("try_")) {
                bl = true;
                string = string.substring(4);
            }
            try {
                MessageQueueAdapter messageQueueAdapter = (MessageQueueAdapter)TypedProxyPullSupplierImpl.this.messageQueueMap_.get(string);
                Message message = bl ? messageQueueAdapter.getMessageNoBlock() : messageQueueAdapter.getMessageBlocking();
                try {
                    NVList nVList;
                    if (message == null) {
                        nVList = (NVList)TypedProxyPullSupplierImpl.this.invalidResponses_.get(string);
                        if (bl) {
                            serverRequest.set_result(TypedProxyPullSupplierImpl.this.falseAny_);
                        }
                    } else {
                        nVList = TypedProxyPullSupplierImpl.this.prepareResponse(message);
                        if (bl) {
                            serverRequest.set_result(TypedProxyPullSupplierImpl.this.trueAny_);
                        }
                    }
                    serverRequest.arguments(nVList);
                }
                finally {
                    if (message != null) {
                        message.dispose();
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public String[] _all_interfaces(POA pOA, byte[] byArray) {
            return this.supportedInterfaces_;
        }

        public POA _default_POA() {
            return TypedProxyPullSupplierImpl.this.getPOA();
        }
    }
}

