/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.xml.checker.beanchildren.ext;

import java.util.Map;
import java.util.Set;
import javax.inject.DefinitionException;
import org.dom4j.Element;
import org.jboss.webbeans.introspector.AnnotatedClass;
import org.jboss.webbeans.xml.ParseXmlHelper;
import org.jboss.webbeans.xml.XmlEnvironment;
import org.jboss.webbeans.xml.checker.beanchildren.ext.AbstractBeanChildrenChecker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NotSimpleBeanChildrenChecker
extends AbstractBeanChildrenChecker {
    public NotSimpleBeanChildrenChecker(XmlEnvironment environment, Map<String, Set<String>> packagesMap) {
        super(environment, packagesMap);
    }

    @Override
    protected void checkForInterceptorChild(Element beanElement) {
        if (ParseXmlHelper.findElementsInEeNamespace(beanElement, "Interceptor").size() > 1) {
            throw new DefinitionException("Not a simple bean '" + beanElement.getName() + "' contains direct child <" + "Interceptor" + ">");
        }
    }

    @Override
    protected void checkForDecoratorChild(Element beanElement) {
        if (ParseXmlHelper.findElementsInEeNamespace(beanElement, "Decorator").size() > 1) {
            throw new DefinitionException("Not a simple bean '" + beanElement.getName() + "' contains direct child <" + "Decorator" + ">");
        }
    }

    @Override
    protected void checkChildForInterceptorType(Element beanChildElement) {
        throw new DefinitionException("Declaration of not a simple bean '" + beanChildElement.getParent().getName() + "' contains a child <" + beanChildElement.getName() + "> which type is javax.interceptor.Interceptor");
    }

    @Override
    protected void checkChildForDecoratorType(Element beanChildElement) {
        throw new DefinitionException("Declaration of not a simple bean '" + beanChildElement.getParent().getName() + "' contains a child <" + beanChildElement.getName() + "> which type is javax.decorator.Decorator");
    }

    @Override
    protected void checkForConstructor(Element beanElement, AnnotatedClass<?> beanClass) {
    }

    @Override
    protected void checkRIBean(Element beanElement, AnnotatedClass<?> beanClass) {
        throw new DefinitionException("It is impossible determine some kind of resource in not Resource Bean");
    }
}

