/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.proxy.clustered.registry;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jboss.aspects.remoting.FamilyWrapper;
import org.jboss.ejb3.proxy.clustered.familyname.ClusterFamilyNamePolicy;
import org.jboss.ejb3.proxy.clustered.familyname.InvokerLocatorProtocolClusterFamilyNamePolicy;
import org.jboss.ejb3.proxy.clustered.registry.ProxyClusteringInfo;
import org.jboss.ejb3.proxy.clustered.registry.ProxyClusteringRegistryListener;
import org.jboss.ha.client.loadbalance.LoadBalancePolicy;
import org.jboss.ha.client.loadbalance.RoundRobin;
import org.jboss.ha.client.loadbalance.aop.FirstAvailable;
import org.jboss.ha.framework.interfaces.DistributedReplicantManager;
import org.jboss.ha.framework.interfaces.HAPartition;
import org.jboss.ha.framework.server.HAPartitionLocator;
import org.jboss.ha.framework.server.HATarget;
import org.jboss.logging.Logger;
import org.jboss.metadata.ejb.jboss.ClusterConfigMetaData;
import org.jboss.metadata.ejb.jboss.JBossSessionBeanMetaData;
import org.jboss.remoting.InvokerLocator;
import org.jboss.util.StringPropertyReplacer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxyClusteringRegistry
implements DistributedReplicantManager.ReplicantListener {
    private static final Logger log = Logger.getLogger(ProxyClusteringRegistry.class);
    private List<ProxyClusteringRegistryListener> listeners = new ArrayList<ProxyClusteringRegistryListener>();
    private ClusterFamilyNamePolicy<InvokerLocator> clusterFamilyNamePolicy;
    private Map<String, Class<LoadBalancePolicy>> loadBalancePolicies;
    private Map<String, ProxyClusteringInfo> beanInfosByFamilyName = new ConcurrentHashMap<String, ProxyClusteringInfo>();
    private Map<String, ProxyClusteringInfo> beanInfosByProxyFactory = new ConcurrentHashMap<String, ProxyClusteringInfo>();
    private ConcurrentMap<String, Map<String, HATarget>> haTargetsByContainerName = new ConcurrentHashMap<String, Map<String, HATarget>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerListener(ProxyClusteringRegistryListener listener) {
        List<ProxyClusteringRegistryListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterListener(ProxyClusteringRegistryListener listener) {
        List<ProxyClusteringRegistryListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProxyClusteringInfo registerClusteredBean(String containerName, String proxyFactoryName, JBossSessionBeanMetaData metadata, InvokerLocator locator) throws Exception {
        ClusterConfigMetaData clusterMetadata = metadata.getClusterConfig();
        String partitionName = ProxyClusteringRegistry.getPartitionName(clusterMetadata);
        String familyInfoName = this.getClusterFamilyNamePolicy().getClusterFamilyName(containerName, locator, partitionName);
        HAPartition partition = HAPartitionLocator.getHAPartitionLocator().getHAPartition(partitionName, null);
        HATarget hatarget = new HATarget(partition, familyInfoName, (Serializable)locator, 2);
        FamilyWrapper wrapper = new FamilyWrapper(familyInfoName, (List)hatarget.getReplicants());
        String lbpClassKey = clusterMetadata.getLoadBalancePolicy();
        Class<? extends LoadBalancePolicy> lbPolicyClass = this.getLoadBalancePolicyClass(lbpClassKey, metadata.isStateful());
        lbpClassKey = clusterMetadata.getHomeLoadBalancePolicy();
        Class<? extends LoadBalancePolicy> homeLBPolicyClass = this.getLoadBalancePolicyClass(lbpClassKey, false);
        ProxyClusteringInfo info = new ProxyClusteringInfo(containerName, proxyFactoryName, partitionName, wrapper, lbPolicyClass, homeLBPolicyClass, hatarget);
        this.registerBeanClusteringInfo(info);
        DistributedReplicantManager drm = partition.getDistributedReplicantManager();
        drm.registerListener(familyInfoName, (DistributedReplicantManager.ReplicantListener)this);
        ArrayList<ProxyClusteringRegistryListener> toNotify = null;
        List<ProxyClusteringRegistryListener> list = this.listeners;
        synchronized (list) {
            toNotify = new ArrayList<ProxyClusteringRegistryListener>(this.listeners);
        }
        for (ProxyClusteringRegistryListener listener : toNotify) {
            listener.beanClusteringInfoAdded(info);
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterClusteredBean(ProxyClusteringInfo info) {
        String familyName = info.getFamilyWrapper().get().getFamilyName();
        info.getHaTarget().destroy();
        HAPartition partition = HAPartitionLocator.getHAPartitionLocator().getHAPartition(info.getPartitionName(), null);
        partition.getDistributedReplicantManager().unregisterListener(familyName, (DistributedReplicantManager.ReplicantListener)this);
        String containerName = info.getContainerName();
        this.beanInfosByFamilyName.remove(familyName);
        this.beanInfosByProxyFactory.remove(info.getProxyFactoryName());
        Map haTargets = (Map)this.haTargetsByContainerName.get(containerName);
        if (haTargets != null) {
            haTargets.remove(familyName);
            if (haTargets.size() == 0) {
                this.haTargetsByContainerName.remove(containerName);
            }
        }
        ArrayList<ProxyClusteringRegistryListener> toNotify = null;
        List<ProxyClusteringRegistryListener> list = this.listeners;
        synchronized (list) {
            toNotify = new ArrayList<ProxyClusteringRegistryListener>(this.listeners);
        }
        for (ProxyClusteringRegistryListener listener : toNotify) {
            listener.beanClusteringInfoRemoved(info);
        }
    }

    public ProxyClusteringInfo getBeanClusteringInfo(String proxyFactoryKey) {
        return this.beanInfosByProxyFactory.get(proxyFactoryKey);
    }

    public Map<String, HATarget> getHATargets(String containerName) {
        Map<String, Object> containerMap = new HashMap<String, HATarget>();
        Map existing = this.haTargetsByContainerName.putIfAbsent(containerName, containerMap);
        if (existing != null) {
            containerMap = existing;
        }
        return containerMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replicantsChanged(String key, List newReplicants, int newReplicantsViewId, boolean merge) {
        ProxyClusteringInfo info = this.beanInfosByFamilyName.get(key);
        if (info != null) {
            info.getFamilyWrapper().get().updateClusterInfo(newReplicants, (long)newReplicantsViewId);
            ArrayList<ProxyClusteringRegistryListener> toNotify = null;
            List<ProxyClusteringRegistryListener> list = this.listeners;
            synchronized (list) {
                toNotify = new ArrayList<ProxyClusteringRegistryListener>(this.listeners);
            }
            for (ProxyClusteringRegistryListener listener : toNotify) {
                listener.clusterTopologyChanged(info);
            }
        }
    }

    public synchronized ClusterFamilyNamePolicy<InvokerLocator> getClusterFamilyNamePolicy() {
        if (this.clusterFamilyNamePolicy == null) {
            this.clusterFamilyNamePolicy = new InvokerLocatorProtocolClusterFamilyNamePolicy();
        }
        return this.clusterFamilyNamePolicy;
    }

    public void setClusterFamilyNamePolicy(ClusterFamilyNamePolicy<InvokerLocator> clusterFamilyNamePolicy) {
        this.clusterFamilyNamePolicy = clusterFamilyNamePolicy;
    }

    public Map<String, Class<LoadBalancePolicy>> getLoadBalancePolicies() {
        return this.loadBalancePolicies;
    }

    public void setLoadBalancePolicies(Map<String, Class<LoadBalancePolicy>> loadBalancePolicies) {
        this.loadBalancePolicies = loadBalancePolicies;
    }

    private Class<? extends LoadBalancePolicy> getLoadBalancePolicyClass(String lbpClassKey, boolean defaultSticky) {
        Class<Object> lbPolicyClass;
        block8: {
            if (lbpClassKey == null || lbpClassKey.length() == 0 || lbpClassKey.equals("LoadBalancePolicy")) {
                return defaultSticky ? FirstAvailable.class : RoundRobin.class;
            }
            Class<LoadBalancePolicy> clazz = lbPolicyClass = this.loadBalancePolicies == null ? null : this.loadBalancePolicies.get(lbpClassKey);
            if (lbPolicyClass == null) {
                String className = lbpClassKey;
                if (lbpClassKey.indexOf(46) < 0) {
                    className = RoundRobin.class.getPackage().getName() + "." + lbpClassKey;
                }
                try {
                    lbPolicyClass = Thread.currentThread().getContextClassLoader().loadClass(className);
                }
                catch (ClassNotFoundException e) {
                    if (lbpClassKey.indexOf(46) < 0) {
                        className = FirstAvailable.class.getPackage().getName() + "." + lbpClassKey;
                        try {
                            lbPolicyClass = Thread.currentThread().getContextClassLoader().loadClass(className);
                        }
                        catch (ClassNotFoundException ignored) {
                            // empty catch block
                        }
                    }
                    if (lbPolicyClass != null) break block8;
                    throw new IllegalStateException("Cannot determine LoadBalancePolicy class for key " + lbpClassKey);
                }
            }
        }
        return lbPolicyClass;
    }

    private void registerBeanClusteringInfo(ProxyClusteringInfo info) {
        String containerName = info.getContainerName();
        String familyName = info.getFamilyWrapper().get().getFamilyName();
        this.beanInfosByFamilyName.put(familyName, info);
        this.beanInfosByProxyFactory.put(info.getProxyFactoryName(), info);
        Map<String, HATarget> containerMap = this.getHATargets(containerName);
        containerMap.put(familyName, info.getHaTarget());
    }

    public static String getPartitionName(ClusterConfigMetaData metadata) {
        String value = metadata.getPartitionName();
        try {
            String replacedValue = StringPropertyReplacer.replaceProperties((String)value);
            if (value != replacedValue) {
                log.debug((Object)("Replacing " + ClusterConfigMetaData.class.getSimpleName() + " partitionName property " + value + " with " + replacedValue));
                value = replacedValue;
            }
        }
        catch (Exception e) {
            log.warn((Object)("Unable to replace @Clustered partition attribute " + value + ". Caused by " + e.getClass() + " " + e.getMessage()));
        }
        return value;
    }
}

