/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.container.jboss50.deployment.tomcat;

import java.util.ArrayList;
import java.util.Map;
import javax.servlet.Servlet;
import javax.xml.ws.WebServiceException;
import org.jboss.logging.Logger;
import org.jboss.metadata.javaee.spec.ParamValueMetaData;
import org.jboss.metadata.web.jboss.JBossServletMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.spec.ListenerMetaData;
import org.jboss.wsf.container.jboss50.deployment.tomcat.RewriteResults;
import org.jboss.wsf.container.jboss50.deployment.tomcat.WebMetaDataModifier;
import org.jboss.wsf.spi.deployment.Deployment;

public class WebMetaDataModifierImpl
implements WebMetaDataModifier {
    private static Logger log = Logger.getLogger(WebMetaDataModifierImpl.class);

    public RewriteResults modifyMetaData(Deployment dep) {
        JBossWebMetaData jbwmd = (JBossWebMetaData)dep.getAttachment(JBossWebMetaData.class);
        if (jbwmd == null) {
            throw new WebServiceException("Cannot find web meta data");
        }
        try {
            RewriteResults results = this.modifyMetaData(dep, jbwmd);
            return results;
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception e) {
            throw new WebServiceException((Throwable)e);
        }
    }

    private RewriteResults modifyMetaData(Deployment dep, JBossWebMetaData jbwmd) throws ClassNotFoundException {
        String listenerClass;
        RewriteResults results = new RewriteResults();
        String servletClass = (String)dep.getProperty("org.jboss.ws.webapp.ServletClass");
        if (servletClass == null) {
            throw new IllegalStateException("Cannot obtain context property: org.jboss.ws.webapp.ServletClass");
        }
        Map depCtxParams = (Map)dep.getProperty("org.jboss.ws.webapp.ContextParameterMap");
        if (depCtxParams != null) {
            ArrayList<ParamValueMetaData> contextParams = jbwmd.getContextParams();
            if (contextParams == null) {
                contextParams = new ArrayList<ParamValueMetaData>();
                jbwmd.setContextParams(contextParams);
            }
            for (Map.Entry entry : depCtxParams.entrySet()) {
                ParamValueMetaData param = new ParamValueMetaData();
                param.setParamName((String)entry.getKey());
                param.setParamValue((String)entry.getValue());
                contextParams.add(param);
            }
        }
        if ((listenerClass = (String)dep.getProperty("org.jboss.ws.webapp.ServletContextListener")) != null) {
            ArrayList listeners = jbwmd.getListeners();
            if (listeners == null) {
                listeners = new ArrayList();
                jbwmd.setListeners(listeners);
            }
            ListenerMetaData listener = new ListenerMetaData();
            listener.setListenerClass(listenerClass);
        }
        for (JBossServletMetaData servlet : jbwmd.getServlets()) {
            ArrayList<ParamValueMetaData> initParams = servlet.getInitParam();
            if (initParams == null) {
                initParams = new ArrayList<ParamValueMetaData>();
                servlet.setInitParam(initParams);
            }
            String linkName = servlet.getServletName();
            String orgServletClassName = servlet.getServletClass();
            if (orgServletClassName == null) continue;
            Class<?> orgServletClass = null;
            try {
                ClassLoader loader = dep.getInitialClassLoader();
                orgServletClass = loader.loadClass(orgServletClassName);
            }
            catch (ClassNotFoundException ex) {
                log.warn((Object)("Cannot load servlet class: " + orgServletClassName));
            }
            String targetBeanName = null;
            if (this.isAlreadyModified(servlet)) {
                for (ParamValueMetaData initParam : initParams) {
                    String paramName = initParam.getParamName();
                    String paramValue = initParam.getParamValue();
                    if (!"jboss.ws.endpoint".equals(paramName)) continue;
                    targetBeanName = paramValue;
                }
            } else {
                if (orgServletClass != null && Servlet.class.isAssignableFrom(orgServletClass)) {
                    log.info((Object)("Ignore servlet: " + orgServletClassName));
                    continue;
                }
                servlet.setServletClass(servletClass);
                if (!orgServletClassName.equals(servletClass)) {
                    targetBeanName = orgServletClassName;
                    ParamValueMetaData initParam = new ParamValueMetaData();
                    initParam.setParamName("jboss.ws.endpoint");
                    initParam.setParamValue(targetBeanName);
                    initParams.add(initParam);
                }
            }
            if (targetBeanName == null) {
                throw new IllegalStateException("Cannot obtain service endpoint bean for: " + linkName);
            }
            results.sepTargetMap.put(linkName, targetBeanName);
        }
        return results;
    }

    private boolean isAlreadyModified(JBossServletMetaData servlet) {
        for (ParamValueMetaData initParam : servlet.getInitParam()) {
            String paramName = initParam.getParamName();
            if (!"jboss.ws.endpoint".equals(paramName)) continue;
            return true;
        }
        return false;
    }
}

