/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xnio.nio;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.Channel;
import java.nio.channels.Pipe;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.jboss.xnio.IoHandler;
import org.jboss.xnio.IoUtils;
import org.jboss.xnio.channels.ChannelOption;
import org.jboss.xnio.channels.Configurable;
import org.jboss.xnio.channels.StreamChannel;
import org.jboss.xnio.channels.UnsupportedOptionException;
import org.jboss.xnio.log.Logger;
import org.jboss.xnio.nio.HandlerUtils;
import org.jboss.xnio.nio.NioHandle;
import org.jboss.xnio.nio.NioXnio;
import org.jboss.xnio.nio.SelectorUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NioPipeChannelImpl
implements StreamChannel {
    private static final Logger log = Logger.getLogger((String)"org.jboss.xnio.nio.pipe.channel");
    private final Pipe.SourceChannel sourceChannel;
    private final Pipe.SinkChannel sinkChannel;
    private final IoHandler<? super StreamChannel> handler;
    private final NioHandle sourceHandle;
    private final NioHandle sinkHandle;
    private final AtomicBoolean callFlag = new AtomicBoolean(false);
    private final NioXnio nioXnio;
    private final AtomicLong bytes;
    private final AtomicLong messages;
    private final Closeable mbeanHandle;

    private NioPipeChannelImpl(Pipe.SourceChannel sourceChannel, Pipe.SinkChannel sinkChannel, IoHandler<? super StreamChannel> handler, NioXnio nioXnio, AtomicLong bytes, AtomicLong messages, Closeable mbeanHandle) throws IOException {
        this.sourceChannel = sourceChannel;
        this.sinkChannel = sinkChannel;
        this.handler = handler;
        this.nioXnio = nioXnio;
        this.bytes = bytes;
        this.messages = messages;
        this.mbeanHandle = mbeanHandle;
        this.sourceHandle = nioXnio.addReadHandler(sourceChannel, new ReadHandler());
        this.sinkHandle = nioXnio.addWriteHandler(sinkChannel, new WriteHandler());
    }

    static NioPipeChannelImpl create(Pipe.SourceChannel sourceChannel, Pipe.SinkChannel sinkChannel, IoHandler<? super StreamChannel> handler, NioXnio nioXnio, AtomicLong bytes, AtomicLong messages, Closeable mbeanHandle) throws IOException {
        NioPipeChannelImpl channel = new NioPipeChannelImpl(sourceChannel, sinkChannel, handler, nioXnio, bytes, messages, mbeanHandle);
        return channel;
    }

    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        long ret = this.sinkChannel.write(srcs, offset, length);
        if (ret > 0L) {
            this.bytes.addAndGet(ret);
            this.messages.incrementAndGet();
        }
        return ret;
    }

    public long write(ByteBuffer[] srcs) throws IOException {
        long ret = this.sinkChannel.write(srcs);
        if (ret > 0L) {
            this.bytes.addAndGet(ret);
            this.messages.incrementAndGet();
        }
        return ret;
    }

    public int write(ByteBuffer src) throws IOException {
        int ret = this.sinkChannel.write(src);
        if (ret > 0) {
            this.bytes.addAndGet(ret);
            this.messages.incrementAndGet();
        }
        return ret;
    }

    public boolean isOpen() {
        return this.sourceChannel.isOpen() && this.sinkChannel.isOpen();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        IoUtils.safeClose((Closeable)this.sourceChannel);
        try {
            this.sinkChannel.close();
        }
        finally {
            this.nioXnio.removeManaged((Closeable)((Object)this));
            if (!this.callFlag.getAndSet(true)) {
                HandlerUtils.handleClosed(this.handler, this);
            }
            IoUtils.safeClose((Closeable)this.mbeanHandle);
        }
    }

    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        long ret = this.sourceChannel.read(dsts, offset, length);
        return ret;
    }

    public long read(ByteBuffer[] dsts) throws IOException {
        long ret = this.sourceChannel.read(dsts);
        return ret;
    }

    public int read(ByteBuffer dst) throws IOException {
        int ret = this.sourceChannel.read(dst);
        return ret;
    }

    public void suspendReads() {
        try {
            this.sourceHandle.suspend();
        }
        catch (CancelledKeyException cancelledKeyException) {
            // empty catch block
        }
    }

    public void suspendWrites() {
        try {
            this.sinkHandle.suspend();
        }
        catch (CancelledKeyException cancelledKeyException) {
            // empty catch block
        }
    }

    public void resumeReads() {
        try {
            this.sourceHandle.resume(1);
        }
        catch (CancelledKeyException cancelledKeyException) {
            // empty catch block
        }
    }

    public void resumeWrites() {
        try {
            this.sinkHandle.resume(4);
        }
        catch (CancelledKeyException cancelledKeyException) {
            // empty catch block
        }
    }

    public void shutdownReads() throws IOException {
        this.sourceChannel.close();
    }

    public void shutdownWrites() throws IOException {
        this.sinkChannel.close();
    }

    public void awaitReadable() throws IOException {
        SelectorUtils.await(this.nioXnio, this.sourceChannel, 1);
    }

    public void awaitReadable(long time, TimeUnit timeUnit) throws IOException {
        SelectorUtils.await(this.nioXnio, this.sourceChannel, 1, time, timeUnit);
    }

    public void awaitWritable() throws IOException {
        SelectorUtils.await(this.nioXnio, this.sinkChannel, 4);
    }

    public void awaitWritable(long time, TimeUnit timeUnit) throws IOException {
        SelectorUtils.await(this.nioXnio, this.sinkChannel, 4, time, timeUnit);
    }

    public <T> T getOption(ChannelOption<T> option) throws UnsupportedOptionException, IOException {
        throw new UnsupportedOptionException("No options supported");
    }

    public Set<ChannelOption<?>> getOptions() {
        return Collections.emptySet();
    }

    public <T> Configurable setOption(ChannelOption<T> option, T value) throws IllegalArgumentException, IOException {
        throw new UnsupportedOptionException("No options supported");
    }

    public String toString() {
        return String.format("pipe channel (NIO) <%s>", Integer.toString(this.hashCode(), 16));
    }

    private class WriteHandler
    implements Runnable {
        private WriteHandler() {
        }

        public void run() {
            IoHandler handler = NioPipeChannelImpl.this.handler;
            try {
                handler.handleWritable((Channel)((Object)NioPipeChannelImpl.this));
            }
            catch (Throwable t) {
                log.error(t, "Write handler threw an exception", new Object[0]);
            }
        }
    }

    private class ReadHandler
    implements Runnable {
        private ReadHandler() {
        }

        public void run() {
            IoHandler handler = NioPipeChannelImpl.this.handler;
            try {
                handler.handleReadable((Channel)((Object)NioPipeChannelImpl.this));
            }
            catch (Throwable t) {
                log.error(t, "Read handler threw an exception", new Object[0]);
            }
        }
    }
}

