/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.annotation.creator;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.Collection;
import java.util.Set;
import javax.persistence.PersistenceUnit;
import org.jboss.metadata.annotation.creator.AbstractInjectionTargetProcessor;
import org.jboss.metadata.annotation.creator.ProcessorUtils;
import org.jboss.metadata.annotation.finder.AnnotationFinder;
import org.jboss.metadata.javaee.spec.PersistenceUnitReferenceMetaData;
import org.jboss.metadata.javaee.spec.PersistenceUnitReferencesMetaData;
import org.jboss.metadata.javaee.spec.ResourceInjectionTargetMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPersistenceUnitProcessor<E extends AnnotatedElement>
extends AbstractInjectionTargetProcessor<E> {
    protected AbstractPersistenceUnitProcessor(AnnotationFinder<AnnotatedElement> finder) {
        super(finder);
    }

    public void process(PersistenceUnitReferencesMetaData metaData, E element) {
        PersistenceUnit annotation = this.finder.getAnnotation(element, PersistenceUnit.class);
        if (annotation == null) {
            return;
        }
        this.process(metaData, element, annotation);
    }

    protected void process(PersistenceUnitReferencesMetaData refs, E element, PersistenceUnit annotation) {
        PersistenceUnitReferenceMetaData ref = this.createPU(element, annotation);
        this.addReference(refs, ref);
    }

    protected abstract String getName(E var1);

    protected abstract String getInjectionName(E var1);

    protected PersistenceUnitReferenceMetaData createPU(E element, PersistenceUnit annotation) {
        String injectionName;
        Set<ResourceInjectionTargetMetaData> injectionTargets;
        PersistenceUnitReferenceMetaData ref = new PersistenceUnitReferenceMetaData();
        String name = annotation.name();
        if (name.length() == 0) {
            name = this.getName(element);
        }
        ref.setPersistenceUnitRefName(name);
        if (annotation.unitName().length() != 0) {
            ref.setPersistenceUnitName(annotation.unitName());
        }
        if ((injectionTargets = ProcessorUtils.getInjectionTargets(injectionName = this.getInjectionName(element), element)) != null) {
            ref.setInjectionTargets(injectionTargets);
        }
        return ref;
    }

    public Collection<Class<? extends Annotation>> getAnnotationTypes() {
        return ProcessorUtils.createAnnotationSet(PersistenceUnit.class);
    }
}

