/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.invocation;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jboss.cache.Fqn;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.transaction.MVCCTransactionContext;
import org.jboss.cache.transaction.TransactionContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MVCCInvocationContext
extends InvocationContext {
    private HashMap<Fqn, NodeSPI> lookedUpNodes = null;
    private MVCCTransactionContext mvccTCtx;

    @Override
    public void setTransactionContext(TransactionContext transactionContext) {
        super.setTransactionContext(transactionContext);
        this.mvccTCtx = (MVCCTransactionContext)transactionContext;
    }

    @Override
    public NodeSPI lookUpNode(Fqn fqn) {
        if (this.mvccTCtx != null) {
            return this.mvccTCtx.lookUpNode(fqn);
        }
        return this.lookedUpNodes == null ? null : this.lookedUpNodes.get(fqn);
    }

    @Override
    public void putLookedUpNode(Fqn f, NodeSPI n) {
        if (this.mvccTCtx != null) {
            this.mvccTCtx.putLookedUpNode(f, n);
        } else {
            if (this.lookedUpNodes == null) {
                this.lookedUpNodes = new HashMap(4);
            }
            this.lookedUpNodes.put(f, n);
        }
    }

    @Override
    public void putLookedUpNodes(Map<Fqn, NodeSPI> lookedUpNodes) {
        if (this.mvccTCtx != null) {
            this.mvccTCtx.putLookedUpNodes(lookedUpNodes);
        } else if (this.lookedUpNodes == null) {
            this.lookedUpNodes = new HashMap<Fqn, NodeSPI>(lookedUpNodes);
        } else {
            lookedUpNodes.putAll(lookedUpNodes);
        }
    }

    @Override
    public void clearLookedUpNodes() {
        if (this.lookedUpNodes != null) {
            this.lookedUpNodes.clear();
        }
    }

    @Override
    public Map<Fqn, NodeSPI> getLookedUpNodes() {
        if (this.mvccTCtx != null) {
            return this.mvccTCtx.getLookedUpNodes();
        }
        return this.lookedUpNodes == null ? Collections.emptyMap() : this.lookedUpNodes;
    }

    @Override
    public void reset() {
        super.reset();
        if (this.lookedUpNodes != null) {
            this.lookedUpNodes.clear();
            this.lookedUpNodes = null;
        }
    }

    @Override
    public InvocationContext copy() {
        MVCCInvocationContext copy = new MVCCInvocationContext();
        this.doCopy(copy);
        if (this.lookedUpNodes != null) {
            copy.lookedUpNodes = (HashMap)this.lookedUpNodes.clone();
        }
        return copy;
    }
}

