/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.newsletter;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.exoplatform.commons.utils.ISO8601;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.cms.impl.DMSConfiguration;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.mail.MailService;
import org.exoplatform.services.mail.Message;
import org.exoplatform.services.wcm.newsletter.handler.NewsletterCategoryHandler;
import org.exoplatform.services.wcm.newsletter.handler.NewsletterEntryHandler;
import org.exoplatform.services.wcm.newsletter.handler.NewsletterManageUserHandler;
import org.exoplatform.services.wcm.newsletter.handler.NewsletterPublicUserHandler;
import org.exoplatform.services.wcm.newsletter.handler.NewsletterSubscriptionHandler;
import org.exoplatform.services.wcm.newsletter.handler.NewsletterTemplateHandler;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewsletterManagerService {
    private NewsletterCategoryHandler categoryHandler;
    private NewsletterSubscriptionHandler subscriptionHandler;
    private NewsletterEntryHandler entryHandler;
    private NewsletterTemplateHandler templateHandler;
    private NewsletterManageUserHandler manageUserHandler;
    private NewsletterPublicUserHandler publicUserHandler;
    private RepositoryService repositoryService;
    private String repositoryName;
    private String workspaceName;
    private static Log log = ExoLogger.getLogger(NewsletterManagerService.class);

    public NewsletterManagerService(InitParams initParams, DMSConfiguration dmsConfiguration) {
        log.info((Object)"Starting NewsletterManagerService ... ");
        this.repositoryName = initParams.getValueParam("repository").getValue();
        this.workspaceName = initParams.getValueParam("workspace").getValue();
        this.categoryHandler = new NewsletterCategoryHandler(this.repositoryName, this.workspaceName);
        this.subscriptionHandler = new NewsletterSubscriptionHandler(this.repositoryName, this.workspaceName);
        this.entryHandler = new NewsletterEntryHandler(this.repositoryName, this.workspaceName);
        this.manageUserHandler = new NewsletterManageUserHandler(this.repositoryName, this.workspaceName);
        this.publicUserHandler = new NewsletterPublicUserHandler(this.repositoryName, this.workspaceName);
        this.templateHandler = new NewsletterTemplateHandler(this.repositoryName, this.workspaceName);
        this.repositoryService = (RepositoryService)WCMCoreUtils.getService(RepositoryService.class);
    }

    public NewsletterCategoryHandler getCategoryHandler() {
        return this.categoryHandler;
    }

    public NewsletterSubscriptionHandler getSubscriptionHandler() {
        return this.subscriptionHandler;
    }

    public NewsletterEntryHandler getEntryHandler() {
        return this.entryHandler;
    }

    public NewsletterTemplateHandler getTemplateHandler() {
        return this.templateHandler;
    }

    public List<String> getAllBannedUser() throws Exception {
        ManageableRepository manageableRepository = this.repositoryService.getRepository(this.repositoryName);
        SessionProvider sessionProvider = WCMCoreUtils.getSystemSessionProvider();
        Session session = sessionProvider.getSession(this.workspaceName, manageableRepository);
        ArrayList<String> listEmails = new ArrayList<String>();
        try {
            QueryManager queryManager = session.getWorkspace().getQueryManager();
            String sqlQuery = "select * from exo:newsletterUser where exo:newsletterUserBanned='true' or exo:newsletterUserConfirm='false'";
            Query query = queryManager.createQuery(sqlQuery, "sql");
            QueryResult queryResult = query.execute();
            NodeIterator nodeIterator = queryResult.getNodes();
            while (nodeIterator.hasNext()) {
                listEmails.add(nodeIterator.nextNode().getProperty("exo:newsletterUserMail").getString());
            }
        }
        catch (RepositoryException repositoryException) {
            log.info((Object)"User node is not created!");
        }
        catch (Exception ex) {
            log.error((Object)"Error when get all users who can't get newsletter: ", ex.fillInStackTrace());
        }
        return listEmails;
    }

    public NewsletterManageUserHandler getManageUserHandler() {
        return this.manageUserHandler;
    }

    public NewsletterPublicUserHandler getPublicUserHandler() {
        return this.publicUserHandler;
    }

    public void sendNewsletter() throws Exception {
        List<String> listBannedEmail = this.getAllBannedUser();
        ManageableRepository manageableRepository = this.repositoryService.getRepository(this.repositoryName);
        SessionProvider sessionProvider = WCMCoreUtils.getSystemSessionProvider();
        Session session = sessionProvider.getSession(this.workspaceName, manageableRepository);
        MailService mailService = (MailService)WCMCoreUtils.getService(MailService.class);
        Message message = null;
        QueryManager queryManager = session.getWorkspace().getQueryManager();
        String sqlQuery = "SELECT * FROM exo:newsletterEntry WHERE exo:newsletterEntryStatus LIKE '%awaiting%' AND exo:newsletterEntryDate <= TIMESTAMP '" + ISO8601.format((Calendar)Calendar.getInstance()) + "'";
        Query query = queryManager.createQuery(sqlQuery, "sql");
        QueryResult queryResult = query.execute();
        NodeIterator nodeIterator = queryResult.getNodes();
        while (nodeIterator.hasNext()) {
            Node newsletterEntry = nodeIterator.nextNode();
            Node subscriptionNode = newsletterEntry.getParent();
            List<String> listEmailAddress = null;
            if (subscriptionNode.hasProperty("exo:newsletterSubscribedUser")) {
                listEmailAddress = this.convertValuesToArray(subscriptionNode.getProperty("exo:newsletterSubscribedUser").getValues(), listBannedEmail);
            }
            if (listEmailAddress != null && listEmailAddress.size() > 0) {
                message = new Message();
                message.setTo(listEmailAddress.get(0));
                String receiver = "";
                for (int i = 1; i < listEmailAddress.size(); ++i) {
                    receiver = receiver + listEmailAddress.get(i) + ",";
                }
                message.setBCC(receiver);
                message.setSubject(newsletterEntry.getProperty("exo:title").getString());
                message.setBody(this.entryHandler.getContent(sessionProvider, newsletterEntry));
                message.setMimeType("text/html");
                try {
                    mailService.sendMessage(message);
                }
                catch (Exception e) {
                    log.error((Object)"Error when send newsletter: ", e.fillInStackTrace());
                }
            }
            newsletterEntry.setProperty("exo:newsletterEntryStatus", "sent");
        }
        session.save();
    }

    public void sendVerificationMail(String email) throws RepositoryException, RepositoryConfigurationException {
    }

    private List<String> convertValuesToArray(Value[] values, List<String> listBannedUser) {
        ArrayList<String> listString = new ArrayList<String>();
        String email = "";
        for (Value value : values) {
            try {
                email = value.getString();
                if (listBannedUser.contains(email)) continue;
                listString.add(email);
            }
            catch (Exception e) {
                log.error((Object)"Error when convert values to array: ", e.fillInStackTrace());
            }
        }
        return listString;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public void setRepositoryName(String repositoryName) {
        this.repositoryName = repositoryName;
    }

    public String getWorkspaceName() {
        return this.workspaceName;
    }

    public void setWorkspaceName(String workspaceName) {
        this.workspaceName = workspaceName;
    }
}

