/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.thumbnail.impl;

import java.awt.image.BufferedImage;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.jcr.Node;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.cms.thumbnail.ThumbnailPlugin;
import org.exoplatform.services.cms.thumbnail.impl.ThumbnailType;
import org.icepdf.core.exceptions.PDFException;
import org.icepdf.core.exceptions.PDFSecurityException;
import org.icepdf.core.pobjects.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PDFThumbnailPlugin
implements ComponentPlugin,
ThumbnailPlugin {
    private ThumbnailType config;
    private String description;
    private String name;

    public PDFThumbnailPlugin(InitParams initParams) throws Exception {
        this.config = (ThumbnailType)initParams.getObjectParamValues(ThumbnailType.class).get(0);
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public BufferedImage getBufferedImage(Node contentNode, String nodePath) throws Exception {
        Document document = new Document();
        try {
            InputStream input = contentNode.getProperty("jcr:data").getStream();
            document.setInputStream(input, nodePath);
        }
        catch (PDFException ex) {
            System.out.println("Error parsing PDF document " + (Object)((Object)ex));
        }
        catch (PDFSecurityException ex) {
            System.out.println("Error encryption not supported " + (Object)((Object)ex));
        }
        catch (FileNotFoundException ex) {
            System.out.println("Error file not found " + ex);
        }
        catch (IOException ex) {
            System.out.println("Error handling PDF document " + ex);
        }
        BufferedImage image = (BufferedImage)document.getPageImage(0, 1, 2, 0.0f, 1.0f);
        document.dispose();
        return image;
    }

    @Override
    public List<String> getMimeTypes() {
        return this.config.getMimeTypes();
    }
}

