/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Weight;

public abstract class Query
implements Serializable,
Cloneable {
    private float boost = 1.0f;

    public void setBoost(float b) {
        this.boost = b;
    }

    public float getBoost() {
        return this.boost;
    }

    public abstract String toString(String var1);

    public String toString() {
        return this.toString("");
    }

    protected Weight createWeight(Searcher searcher) throws IOException {
        throw new UnsupportedOperationException();
    }

    public Weight weight(Searcher searcher) throws IOException {
        Query query = searcher.rewrite(this);
        Weight weight = query.createWeight(searcher);
        float sum = weight.sumOfSquaredWeights();
        float norm = this.getSimilarity(searcher).queryNorm(sum);
        weight.normalize(norm);
        return weight;
    }

    public Query rewrite(IndexReader reader) throws IOException {
        return this;
    }

    public Query combine(Query[] queries) {
        HashSet<Query> uniques = new HashSet<Query>();
        for (int i = 0; i < queries.length; ++i) {
            Query query = queries[i];
            BooleanClause[] clauses = null;
            boolean splittable = query instanceof BooleanQuery;
            if (splittable) {
                BooleanQuery bq = (BooleanQuery)query;
                splittable = bq.isCoordDisabled();
                clauses = bq.getClauses();
                for (int j = 0; splittable && j < clauses.length; ++j) {
                    splittable = clauses[j].getOccur() == BooleanClause.Occur.SHOULD;
                }
            }
            if (splittable) {
                for (int j = 0; j < clauses.length; ++j) {
                    uniques.add(clauses[j].getQuery());
                }
                continue;
            }
            uniques.add(query);
        }
        if (uniques.size() == 1) {
            return (Query)uniques.iterator().next();
        }
        Iterator it = uniques.iterator();
        BooleanQuery result = new BooleanQuery(true);
        while (it.hasNext()) {
            result.add((Query)it.next(), BooleanClause.Occur.SHOULD);
        }
        return result;
    }

    public void extractTerms(Set terms) {
        throw new UnsupportedOperationException();
    }

    public static Query mergeBooleanQueries(Query[] queries) {
        HashSet<BooleanClause> allClauses = new HashSet<BooleanClause>();
        for (int i = 0; i < queries.length; ++i) {
            BooleanClause[] clauses = ((BooleanQuery)queries[i]).getClauses();
            for (int j = 0; j < clauses.length; ++j) {
                allClauses.add(clauses[j]);
            }
        }
        boolean coordDisabled = queries.length == 0 ? false : ((BooleanQuery)queries[0]).isCoordDisabled();
        BooleanQuery result = new BooleanQuery(coordDisabled);
        Iterator i = allClauses.iterator();
        while (i.hasNext()) {
            result.add((BooleanClause)i.next());
        }
        return result;
    }

    public Similarity getSimilarity(Searcher searcher) {
        return searcher.getSimilarity();
    }

    public Object clone() {
        try {
            return (Query)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Clone not supported: " + e.getMessage());
        }
    }
}

