/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xnio.channels;

import org.jboss.xnio.channels.ChannelOption;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlainChannelOption<T>
implements ChannelOption<T> {
    private static final long serialVersionUID = -8427767721179764175L;
    private final String name;
    private final Class<T> type;

    public PlainChannelOption(String name, Class<T> type) {
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        if (type == null) {
            throw new NullPointerException("type is null");
        }
        this.name = name;
        this.type = type;
    }

    public static <T> ChannelOption<T> createOption(String name, Class<T> type) {
        return new PlainChannelOption<T>(name, type);
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof ChannelOption) {
            ChannelOption other = (ChannelOption)o;
            return this == other || this.name.equals(other.getName()) && this.type.equals(other.getType());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return 31 * this.name.hashCode() + this.type.hashCode();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Class<T> getType() {
        return this.type;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Option \"").append(this.name).append("\", type ").append(this.type.getName());
        builder.append(" (").append(super.toString()).append(')');
        return builder.toString();
    }

    @Override
    public T valueOf(String string) throws IllegalArgumentException {
        Class<T> type = this.type;
        if (type == Boolean.class) {
            return type.cast(Boolean.valueOf(string));
        }
        if (type == Integer.class) {
            return type.cast(Integer.valueOf(string));
        }
        if (type == String.class) {
            return type.cast(string);
        }
        throw new IllegalArgumentException("Unknown type " + type.getName());
    }
}

