/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.remoting.event;

import java.io.Serializable;
import javax.management.BadAttributeValueExpException;
import javax.management.BadBinaryOpValueExpException;
import javax.management.BadStringOperationException;
import javax.management.InvalidApplicationException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.QueryExp;

public class ClassQueryExp
implements QueryExp,
Serializable {
    private static final long serialVersionUID = -4099952623687795850L;
    public static final int AND = 1;
    public static final int OR = 2;
    String[] classes;
    int operator;
    transient MBeanServer mBeanServer;

    public ClassQueryExp(Class[] cl) {
        this(cl, 2);
    }

    public ClassQueryExp(Class cl) {
        this(new Class[]{cl}, 1);
    }

    public ClassQueryExp(Class cl, int operator) {
        this(new Class[]{cl}, operator);
    }

    public ClassQueryExp(Class[] cl, int operator) {
        this.classes = new String[cl.length];
        for (int c = 0; c < cl.length; ++c) {
            this.classes[c] = cl[c].getName();
        }
        this.operator = operator;
    }

    public boolean apply(ObjectName objectName) throws BadStringOperationException, BadBinaryOpValueExpException, BadAttributeValueExpException, InvalidApplicationException {
        try {
            for (int c = 0; c < this.classes.length; ++c) {
                boolean value = this.mBeanServer.isInstanceOf(objectName, this.classes[c]);
                if (value && this.operator == 2) {
                    return true;
                }
                if (value || this.operator != 1) continue;
                return false;
            }
            return this.operator != 2;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public void setMBeanServer(MBeanServer mBeanServer) {
        this.mBeanServer = mBeanServer;
    }
}

