/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.util;

import java.beans.Introspector;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.inject.BindingType;
import javax.inject.ExecutionException;
import org.jboss.webbeans.util.reflection.ParameterizedTypeImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Reflections {
    public static String getPropertyName(Method method) {
        String methodName = method.getName();
        if (methodName.matches("^(get).*") && method.getParameterTypes().length == 0) {
            return Introspector.decapitalize(methodName.substring(3));
        }
        if (methodName.matches("^(is).*") && method.getParameterTypes().length == 0) {
            return Introspector.decapitalize(methodName.substring(2));
        }
        return null;
    }

    public static boolean isFinal(Class<?> clazz) {
        return Modifier.isFinal(clazz.getModifiers());
    }

    public static boolean isFinal(Member member) {
        return Modifier.isFinal(member.getModifiers());
    }

    public static boolean isTypeOrAnyMethodFinal(Class<?> type) {
        if (Reflections.isFinal(type)) {
            return true;
        }
        for (Method method : type.getDeclaredMethods()) {
            if (!Reflections.isFinal(method)) continue;
            return true;
        }
        return false;
    }

    public static boolean isPrimitive(Class<?> type) {
        return type.isPrimitive();
    }

    public static boolean isStatic(Class<?> type) {
        return Modifier.isStatic(type.getModifiers());
    }

    public static boolean isStatic(Member member) {
        return Modifier.isStatic(member.getModifiers());
    }

    public static boolean isTransient(Member member) {
        return Modifier.isTransient(member.getModifiers());
    }

    public static boolean isAbstract(Class<?> clazz) {
        return Modifier.isAbstract(clazz.getModifiers());
    }

    public static boolean isNonMemberInnerClass(Class<?> clazz) {
        return clazz.isMemberClass() && !Reflections.isStatic(clazz);
    }

    public static <T> Constructor<T> getDeclaredConstructor(Class<T> clazz, Class<?> ... parameterTypes) {
        try {
            return clazz.getDeclaredConstructor(parameterTypes);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException("Error accessing constructor (with parameters " + parameterTypes + ") of " + clazz, e);
        }
    }

    public static Type[] getActualTypeArguments(Class<?> clazz) {
        if (clazz.getGenericSuperclass() instanceof ParameterizedType) {
            return ((ParameterizedType)clazz.getGenericSuperclass()).getActualTypeArguments();
        }
        return new Type[0];
    }

    public static boolean isArrayType(Class<?> rawType) {
        return rawType.isArray();
    }

    public static boolean isParameterizedType(Class<?> type) {
        return type.getTypeParameters().length > 0;
    }

    public static Object invokeAndWrap(Method method, Object instance, Object ... parameters) {
        try {
            method.setAccessible(true);
            return method.invoke(instance, parameters);
        }
        catch (IllegalArgumentException e) {
            throw new ExecutionException("Error invoking method " + method.getName() + " on " + method.getDeclaringClass(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new ExecutionException("Error invoking method " + method.getName() + " on " + method.getDeclaringClass(), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new ExecutionException("Error invoking method " + method.getName() + " on " + method.getDeclaringClass(), (Throwable)e);
        }
    }

    public static Object invokeAndWrap(String methodName, Object instance, Object ... parameters) {
        Class[] parameterTypes = new Class[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            parameterTypes[i] = parameters[i].getClass();
        }
        try {
            return Reflections.invokeAndWrap(instance.getClass().getMethod(methodName, parameterTypes), instance, parameters);
        }
        catch (SecurityException e) {
            throw new ExecutionException("Error invoking method " + methodName + " on " + instance.getClass(), (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new ExecutionException("Error invoking method " + methodName + " on " + instance.getClass(), (Throwable)e);
        }
    }

    public static Object getAndWrap(Field field, Object target) {
        try {
            return field.get(target);
        }
        catch (IllegalArgumentException e) {
            throw new ExecutionException("Error getting field " + field.getName() + " on " + field.getDeclaringClass(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new ExecutionException("Error getting field " + field.getName() + " on " + field.getDeclaringClass(), (Throwable)e);
        }
    }

    public static Object getAndWrap(String fieldName, Object target) {
        try {
            return Reflections.getAndWrap(target.getClass().getField(fieldName), target);
        }
        catch (SecurityException e) {
            throw new ExecutionException("Error getting field " + fieldName + " on " + target.getClass(), (Throwable)e);
        }
        catch (NoSuchFieldException e) {
            throw new ExecutionException("Error getting field " + fieldName + " on " + target.getClass(), (Throwable)e);
        }
    }

    public static Method lookupMethod(Method method, Object instance) {
        try {
            return Reflections.lookupMethod(method.getName(), method.getParameterTypes(), instance);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static Method lookupMethod(String methodName, Class<?>[] parameterTypes, Object instance) throws NoSuchMethodException {
        return Reflections.lookupMethod(methodName, parameterTypes, instance.getClass());
    }

    private static Method lookupMethod(String methodName, Class<?>[] parameterTypes, Class<?> c) throws NoSuchMethodException {
        for (Class<?> clazz = c; clazz != null; clazz = clazz.getSuperclass()) {
            for (Class<?> intf : clazz.getInterfaces()) {
                try {
                    return Reflections.lookupMethod(methodName, parameterTypes, intf);
                }
                catch (NoSuchMethodException e) {
                }
            }
            try {
                Method targetMethod = clazz.getDeclaredMethod(methodName, parameterTypes);
                if (!targetMethod.isAccessible()) {
                    targetMethod.setAccessible(true);
                }
                return targetMethod;
            }
            catch (NoSuchMethodException nsme) {
                continue;
            }
        }
        throw new NoSuchMethodException("Method " + methodName + Arrays.asList(parameterTypes).toString().replace("[", "(").replace("]", ")") + " not implemented by instance " + c.getName());
    }

    public static boolean isProxy(Object instance) {
        return instance.getClass().getName().indexOf("_$$_javassist_") > 0;
    }

    @Deprecated
    public static boolean isBindings(Annotation binding) {
        boolean isBindingAnnotation = false;
        if (binding.annotationType().isAnnotationPresent(BindingType.class)) {
            isBindingAnnotation = true;
        }
        return isBindingAnnotation;
    }

    public static boolean isSerializable(Class<?> clazz) {
        return clazz.isPrimitive() || Serializable.class.isAssignableFrom(clazz);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class HierarchyDiscovery {
        private final Type type;
        private Set<Type> types;

        public HierarchyDiscovery(Type type) {
            this.type = type;
        }

        protected void add(Type type) {
            this.types.add(type);
        }

        public Set<Type> getFlattenedTypes() {
            if (this.types == null) {
                this.types = new HashSet<Type>();
                this.discoverTypes(this.type);
            }
            return this.types;
        }

        public Type getResolvedType() {
            return this.resolveType(this.type, this.type);
        }

        private void discoverTypes(Type type) {
            if (type != null) {
                Type rawType;
                this.add(type);
                if (type instanceof Class) {
                    this.discoverFromClass((Class)type);
                } else if (type instanceof ParameterizedType && (rawType = ((ParameterizedType)type).getRawType()) instanceof Class) {
                    this.discoverFromClass((Class)rawType);
                }
            }
        }

        private void discoverFromClass(Class<?> clazz) {
            this.discoverTypes(this.resolveType(this.type, clazz.getGenericSuperclass()));
            for (Type c : clazz.getGenericInterfaces()) {
                this.discoverTypes(this.resolveType(this.type, c));
            }
        }

        private Type resolveType(Type beanType, Type type) {
            if (type instanceof ParameterizedType) {
                if (beanType instanceof ParameterizedType) {
                    return this.resolveParameterizedType((ParameterizedType)beanType, (ParameterizedType)type);
                }
                if (beanType instanceof Class) {
                    return this.resolveType(((Class)beanType).getGenericSuperclass(), (ParameterizedType)type);
                }
            }
            if (type instanceof TypeVariable) {
                if (beanType instanceof ParameterizedType) {
                    return this.resolveTypeParameter((ParameterizedType)beanType, (TypeVariable)type);
                }
                if (beanType instanceof Class) {
                    return this.resolveType(((Class)beanType).getGenericSuperclass(), (TypeVariable)type);
                }
            }
            return type;
        }

        private Type resolveParameterizedType(ParameterizedType beanType, ParameterizedType parameterizedType) {
            Type rawType = parameterizedType.getRawType();
            Type[] actualTypes = parameterizedType.getActualTypeArguments();
            Type resolvedRawType = this.resolveType(beanType, rawType);
            Type[] resolvedActualTypes = new Type[actualTypes.length];
            for (int i = 0; i < actualTypes.length; ++i) {
                resolvedActualTypes[i] = this.resolveType(beanType, actualTypes[i]);
            }
            return new ParameterizedTypeImpl(resolvedRawType, resolvedActualTypes, parameterizedType.getOwnerType());
        }

        private Type resolveTypeParameter(ParameterizedType beanType, TypeVariable<?> typeVariable) {
            Class actualType = (Class)beanType.getRawType();
            TypeVariable<Class<T>>[] typeVariables = actualType.getTypeParameters();
            Type[] actualTypes = beanType.getActualTypeArguments();
            for (int i = 0; i < typeVariables.length; ++i) {
                if (!typeVariables[i].equals(typeVariable)) continue;
                return this.resolveType(this.type, actualTypes[i]);
            }
            Type genericSuperType = actualType.getGenericSuperclass();
            Type type = this.resolveType(genericSuperType, typeVariable);
            if (!(type instanceof TypeVariable)) {
                return type;
            }
            for (Type interfaceType : actualType.getGenericInterfaces()) {
                Type resolvedType = this.resolveType(interfaceType, typeVariable);
                if (resolvedType instanceof TypeVariable) continue;
                return resolvedType;
            }
            return typeVariable;
        }
    }
}

