/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Random;
import org.jboss.logging.Logger;

public class PortUtil {
    private static final Logger log = Logger.getLogger((Class)PortUtil.class);
    private static final int MIN_UNPRIVILEGED_PORT = 1024;
    private static final int MAX_LEGAL_PORT = 65535;
    private static int portCounter = 0;
    private static int retryMax = 50;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean checkPort(final int p, final String host) {
        boolean available = true;
        ServerSocket socket = null;
        try {
            socket = (ServerSocket)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    InetAddress inetAddress = InetAddress.getByName(host);
                    return new ServerSocket(p, 0, inetAddress);
                }
            });
        }
        catch (PrivilegedActionException e) {
            available = false;
            throw (IOException)e.getCause();
        }
        Object var6_7 = null;
        if (socket == null) return available;
        try {
            socket.close();
            return available;
        }
        catch (IOException e2) {}
        return available;
        {
            catch (UnknownHostException e) {
                log.warn((Object)("unknown host: " + host));
                Object var6_8 = null;
                if (socket == null) return available;
                try {
                    socket.close();
                    return available;
                }
                catch (IOException e2) {}
                return available;
            }
            catch (IOException e) {
                if ("Protocol family unavailable".equalsIgnoreCase(e.getMessage()) || "Protocol family not supported".equalsIgnoreCase(e.getMessage())) {
                    log.debug((Object)("perhaps IPv6 is not available: " + e.getMessage()));
                } else {
                    log.debug((Object)("port " + p + " already in use.  Will try another."), e.getCause());
                }
                Object var6_9 = null;
                if (socket == null) return available;
                try {
                    socket.close();
                    return available;
                }
                catch (IOException e2) {}
                return available;
            }
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            if (socket == null) throw throwable;
            try {
                socket.close();
                throw throwable;
            }
            catch (IOException e2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public static int findFreePort(String host) throws IOException {
        int tryCount;
        Integer port = null;
        for (tryCount = 0; port == null && tryCount < retryMax; ++tryCount) {
            port = PortUtil.getFreePort(host);
            if (port == null || PortUtil.checkPort(port, host)) continue;
            port = null;
        }
        if (tryCount >= retryMax) {
            throw new IOException("Can not find a free port for use.");
        }
        return port;
    }

    private static Integer getFreePort(String host) {
        int p = PortUtil.getNextPort();
        if (PortUtil.checkPort(p, host)) {
            return new Integer(p);
        }
        return null;
    }

    private static synchronized int getNextPort() {
        if (portCounter < 65535) {
            return portCounter++;
        }
        portCounter = 1024;
        return 65535;
    }

    public static int getRandomStartingPort() {
        int range = 64512;
        int port = new Random(System.currentTimeMillis()).nextInt(range) + 1024;
        return port;
    }

    public static void main(String[] args) {
        try {
            System.out.println("port - " + PortUtil.findFreePort("localhost"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    static {
        portCounter = PortUtil.getRandomStartingPort();
    }
}

