/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Properties;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Streamable;

public class COMPRESS
extends Protocol {
    BlockingQueue<Deflater> deflater_pool = null;
    BlockingQueue<Inflater> inflater_pool = null;
    int compression_level = 9;
    long min_size = 500L;
    int pool_size = 2;
    static final String name = "COMPRESS";

    public String getName() {
        return name;
    }

    public void init() throws Exception {
        int i;
        this.deflater_pool = new ArrayBlockingQueue<Deflater>(this.pool_size);
        for (i = 0; i < this.pool_size; ++i) {
            this.deflater_pool.add(new Deflater(this.compression_level));
        }
        this.inflater_pool = new ArrayBlockingQueue<Inflater>(this.pool_size);
        for (i = 0; i < this.pool_size; ++i) {
            this.inflater_pool.add(new Inflater());
        }
    }

    public void destroy() {
        for (Deflater deflater : this.deflater_pool) {
            deflater.end();
        }
        for (Inflater inflater : this.inflater_pool) {
            inflater.end();
        }
    }

    public boolean setProperties(Properties props) {
        super.setProperties(props);
        String str = props.getProperty("compression_level");
        if (str != null) {
            this.compression_level = Integer.parseInt(str);
            props.remove("compression_level");
        }
        if ((str = props.getProperty("min_size")) != null) {
            this.min_size = Long.parseLong(str);
            props.remove("min_size");
        }
        if ((str = props.getProperty("pool_size")) != null) {
            this.pool_size = Integer.parseInt(str);
            if (this.pool_size <= 0) {
                this.log.warn((Object)"pool_size must be > 0, setting it to 1");
                this.pool_size = 1;
            }
            props.remove("pool_size");
        }
        if (!props.isEmpty()) {
            this.log.error((Object)("the following properties are not recognized: " + props));
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object down(Event evt) {
        if (evt.getType() != 1) return this.down_prot.down(evt);
        Message msg = (Message)evt.getArg();
        int length = msg.getLength();
        if ((long)length < this.min_size) return this.down_prot.down(evt);
        byte[] payload = msg.getRawBuffer();
        byte[] compressed_payload = new byte[length];
        Deflater deflater = null;
        try {
            try {
                deflater = this.deflater_pool.take();
                deflater.reset();
                deflater.setInput(payload, msg.getOffset(), length);
                deflater.finish();
                deflater.deflate(compressed_payload);
                int compressed_size = deflater.getTotalOut();
                byte[] new_payload = new byte[compressed_size];
                System.arraycopy(compressed_payload, 0, new_payload, 0, compressed_size);
                msg.setBuffer(new_payload);
                msg.putHeader(name, new CompressHeader(length));
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("compressed payload from " + length + " bytes to " + compressed_size + " bytes"));
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
            Object var10_10 = null;
            if (deflater == null) return this.down_prot.down(evt);
            this.deflater_pool.offer(deflater);
            return this.down_prot.down(evt);
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            if (deflater == null) throw throwable;
            this.deflater_pool.offer(deflater);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object up(Event evt) {
        if (evt.getType() != 1) return this.up_prot.up(evt);
        Message msg = (Message)evt.getArg();
        CompressHeader hdr = (CompressHeader)msg.getHeader(name);
        if (hdr == null) return this.up_prot.up(evt);
        byte[] compressed_payload = msg.getRawBuffer();
        if (compressed_payload == null) return this.up_prot.up(evt);
        if (compressed_payload.length <= 0) return this.up_prot.up(evt);
        int original_size = hdr.original_size;
        byte[] uncompressed_payload = new byte[original_size];
        Inflater inflater = null;
        try {
            try {
                Object object;
                inflater = this.inflater_pool.take();
                inflater.reset();
                inflater.setInput(compressed_payload, msg.getOffset(), msg.getLength());
                try {
                    inflater.inflate(uncompressed_payload);
                    if (this.log.isTraceEnabled()) {
                        this.log.trace((Object)("uncompressed " + compressed_payload.length + " bytes to " + original_size + " bytes"));
                    }
                    Message copy = msg.copy(false);
                    copy.setBuffer(uncompressed_payload);
                    object = this.up_prot.up(new Event(1, copy));
                }
                catch (DataFormatException e) {
                    if (this.log.isErrorEnabled()) {
                        this.log.error((Object)"exception on uncompression", (Throwable)e);
                    }
                    Object var11_13 = null;
                    if (inflater == null) return this.up_prot.up(evt);
                    this.inflater_pool.offer(inflater);
                    return this.up_prot.up(evt);
                }
                Object var11_12 = null;
                if (inflater == null) return object;
                this.inflater_pool.offer(inflater);
                return object;
            }
            catch (InterruptedException e2) {
                Thread.currentThread().interrupt();
                Object var11_14 = null;
                if (inflater == null) return this.up_prot.up(evt);
                this.inflater_pool.offer(inflater);
                return this.up_prot.up(evt);
            }
        }
        catch (Throwable throwable) {
            Object var11_15 = null;
            if (inflater == null) throw throwable;
            this.inflater_pool.offer(inflater);
            throw throwable;
        }
    }

    public static class CompressHeader
    extends Header
    implements Streamable {
        int original_size = 0;

        public CompressHeader() {
        }

        public CompressHeader(int s) {
            this.original_size = s;
        }

        public int size() {
            return 4;
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.original_size);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.original_size = in.readInt();
        }

        public void writeTo(DataOutputStream out) throws IOException {
            out.writeInt(this.original_size);
        }

        public void readFrom(DataInputStream in) throws IOException, IllegalAccessException, InstantiationException {
            this.original_size = in.readInt();
        }
    }
}

