/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.tree.selectone;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Item;
import javax.jcr.Node;
import org.exoplatform.ecm.webui.tree.UIBaseNodeTreeSelector;
import org.exoplatform.ecm.webui.tree.UINodeTreeBuilder;
import org.exoplatform.ecm.webui.tree.selectone.UISelectPathPanel;
import org.exoplatform.ecm.webui.tree.selectone.UIWorkspaceList;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.cms.link.NodeFinder;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.ecm.publication.PublicationService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIBreadcumbs;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfigs(value={@ComponentConfig(template="classpath:groovy/ecm/webui/UIContainerWithAction.gtmpl"), @ComponentConfig(type=UIBreadcumbs.class, id="BreadcumbCategoriesOne", template="system:/groovy/webui/core/UIBreadcumbs.gtmpl", events={@EventConfig(listeners={SelectPathActionListener.class})})})
public class UIOneNodePathSelector
extends UIBaseNodeTreeSelector {
    private String[] acceptedNodeTypesInTree = new String[0];
    private String[] acceptedNodeTypesInPathPanel = new String[0];
    private String[] acceptedMimeTypes = new String[0];
    private String[] exceptedNodeTypesInPathPanel = new String[0];
    private String[] exceptedNodeTypesInTree = new String[0];
    private String[] defaultExceptedNodeTypes = new String[]{"exo:symlink"};
    private String repositoryName = null;
    private String workspaceName = null;
    private String rootTreePath = null;
    private boolean isDisable = false;
    private boolean allowPublish = false;
    private boolean alreadyChangePath = false;
    private String rootTaxonomyName = null;

    public UIOneNodePathSelector() throws Exception {
        this.addChild(UIBreadcumbs.class, "BreadcumbCategoriesOne", "BreadcumbCategoriesOne");
        this.addChild(UIWorkspaceList.class, null, null);
        this.addChild(UINodeTreeBuilder.class, null, UINodeTreeBuilder.class.getSimpleName() + this.hashCode());
        ((UISelectPathPanel)this.addChild(UISelectPathPanel.class, null, null)).setShowTrashHomeNode(false);
    }

    public String getRootTaxonomyName() {
        return this.rootTaxonomyName;
    }

    public void setRootTaxonomyName(String rootTaxonomyName) {
        this.rootTaxonomyName = rootTaxonomyName;
    }

    public void init(SessionProvider sessionProvider) throws Exception {
        Node rootNode;
        RepositoryService repositoryService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        ManageableRepository manageableRepository = repositoryService.getRepository(this.repositoryName);
        PublicationService publicationService = (PublicationService)this.getApplicationComponent(PublicationService.class);
        TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
        List templates = templateService.getDocumentTemplates(this.repositoryName);
        if (this.rootTreePath.trim().equals("/")) {
            rootNode = sessionProvider.getSession(this.workspaceName, manageableRepository).getRootNode();
        } else {
            NodeFinder nodeFinder = (NodeFinder)this.getApplicationComponent(NodeFinder.class);
            if (this.rootTreePath.indexOf("${userId}") > -1) {
                String rootTreeOfSpecialDriver;
                String userId = Util.getPortalRequestContext().getRemoteUser();
                this.rootTreePath = rootTreeOfSpecialDriver = this.rootTreePath.replace("${userId}", userId);
            }
            rootNode = (Node)nodeFinder.getItem(this.repositoryName, this.workspaceName, this.rootTreePath);
        }
        UIWorkspaceList uiWorkspaceList = (UIWorkspaceList)this.getChild(UIWorkspaceList.class);
        uiWorkspaceList.setWorkspaceList(this.repositoryName);
        uiWorkspaceList.setIsDisable(this.workspaceName, this.isDisable);
        UINodeTreeBuilder builder = (UINodeTreeBuilder)this.getChild(UINodeTreeBuilder.class);
        builder.setAllowPublish(this.allowPublish, publicationService, templates);
        builder.setAcceptedNodeTypes(this.acceptedNodeTypesInTree);
        builder.setDefaultExceptedNodeTypes(this.defaultExceptedNodeTypes);
        builder.setRootTreeNode(rootNode);
        UISelectPathPanel selectPathPanel = (UISelectPathPanel)this.getChild(UISelectPathPanel.class);
        selectPathPanel.setAllowPublish(this.allowPublish, publicationService, templates);
        selectPathPanel.setAcceptedNodeTypes(this.acceptedNodeTypesInPathPanel);
        selectPathPanel.setAcceptedMimeTypes(this.acceptedMimeTypes);
        selectPathPanel.setExceptedNodeTypes(this.exceptedNodeTypesInPathPanel);
        selectPathPanel.setDefaultExceptedNodeTypes(this.defaultExceptedNodeTypes);
        selectPathPanel.updateGrid();
    }

    public boolean isAllowPublish() {
        return this.allowPublish;
    }

    public void setAllowPublish(boolean allowPublish) {
        this.allowPublish = allowPublish;
    }

    public void setRootNodeLocation(String repository, String workspace, String rootPath) throws Exception {
        this.repositoryName = repository;
        this.workspaceName = workspace;
        this.rootTreePath = rootPath;
    }

    public void setIsDisable(String wsName, boolean isDisable) {
        this.setWorkspaceName(wsName);
        this.isDisable = isDisable;
    }

    public boolean isDisable() {
        return this.isDisable;
    }

    public void setIsShowSystem(boolean isShowSystem) {
        ((UIWorkspaceList)this.getChild(UIWorkspaceList.class)).setIsShowSystem(isShowSystem);
    }

    public void setShowRootPathSelect(boolean isRendered) {
        UIWorkspaceList uiWorkspaceList = (UIWorkspaceList)this.getChild(UIWorkspaceList.class);
        uiWorkspaceList.setShowRootPathSelect(isRendered);
    }

    public String[] getAcceptedNodeTypesInTree() {
        return this.acceptedNodeTypesInTree;
    }

    public void setAcceptedNodeTypesInTree(String[] acceptedNodeTypesInTree) {
        this.acceptedNodeTypesInTree = acceptedNodeTypesInTree;
    }

    public String[] getAcceptedNodeTypesInPathPanel() {
        return this.acceptedNodeTypesInPathPanel;
    }

    public void setAcceptedNodeTypesInPathPanel(String[] acceptedNodeTypesInPathPanel) {
        this.acceptedNodeTypesInPathPanel = acceptedNodeTypesInPathPanel;
    }

    public String[] getExceptedNodeTypesInTree() {
        return this.exceptedNodeTypesInTree;
    }

    public void setExceptedNodeTypesInTree(String[] exceptedNodeTypesInTree) {
        this.exceptedNodeTypesInTree = exceptedNodeTypesInTree;
    }

    public String[] getExceptedNodeTypesInPathPanel() {
        return this.exceptedNodeTypesInPathPanel;
    }

    public void setExceptedNodeTypesInPathPanel(String[] exceptedNodeTypesInPathPanel) {
        this.exceptedNodeTypesInPathPanel = exceptedNodeTypesInPathPanel;
    }

    public String[] getDefaultExceptedNodeTypes() {
        return this.defaultExceptedNodeTypes;
    }

    public String[] getAcceptedMimeTypes() {
        return this.acceptedMimeTypes;
    }

    public void setAcceptedMimeTypes(String[] acceptedMimeTypes) {
        this.acceptedMimeTypes = acceptedMimeTypes;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public void setRepositoryName(String repositoryName) {
        this.repositoryName = repositoryName;
    }

    public String getWorkspaceName() {
        return this.workspaceName;
    }

    public void setWorkspaceName(String workspaceName) {
        this.workspaceName = workspaceName;
    }

    public String getRootTreePath() {
        return this.rootTreePath;
    }

    public void setRootTreePath(String rootTreePath) {
        this.rootTreePath = rootTreePath;
    }

    public void onChange(Node currentNode, Object context) throws Exception {
        UISelectPathPanel selectPathPanel = (UISelectPathPanel)this.getChild(UISelectPathPanel.class);
        selectPathPanel.setParentNode(currentNode);
        selectPathPanel.updateGrid();
        UIBreadcumbs uiBreadcumbs = (UIBreadcumbs)this.getChild(UIBreadcumbs.class);
        String pathName = currentNode.getName();
        NodeFinder nodeFinder = (NodeFinder)this.getApplicationComponent(NodeFinder.class);
        Node rootNode = (Node)nodeFinder.getItem(this.repositoryName, this.workspaceName, this.rootTreePath);
        if (currentNode.equals(rootNode)) {
            pathName = "";
        }
        UIBreadcumbs.LocalPath localPath = new UIBreadcumbs.LocalPath(pathName, pathName);
        List listLocalPath = uiBreadcumbs.getPath();
        StringBuilder buffer = new StringBuilder(1024);
        for (UIBreadcumbs.LocalPath iterLocalPath : listLocalPath) {
            buffer.append("/").append(iterLocalPath.getId());
        }
        if (!this.alreadyChangePath) {
            String path = buffer.toString();
            if (path.startsWith("//")) {
                path = path.substring(1);
            }
            if (!path.startsWith(this.rootTreePath)) {
                path = this.rootTreePath + path;
            }
            if (path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
            if (path.length() == 0) {
                path = "/";
            }
            Node currentBreadcumbsNode = this.getNodeByVirtualPath(path);
            if (currentNode.equals(rootNode) || !currentBreadcumbsNode.equals(rootNode) && currentBreadcumbsNode.getParent().equals(currentNode)) {
                if (listLocalPath != null && listLocalPath.size() > 0) {
                    listLocalPath.remove(listLocalPath.size() - 1);
                }
            } else {
                listLocalPath.add(localPath);
            }
        }
        this.alreadyChangePath = false;
        uiBreadcumbs.setPath(listLocalPath);
    }

    private Node getNodeByVirtualPath(String pathLinkNode) throws Exception {
        NodeFinder nodeFinder_ = (NodeFinder)this.getApplicationComponent(NodeFinder.class);
        Item item = nodeFinder_.getItem(this.repositoryName, this.workspaceName, pathLinkNode);
        return (Node)item;
    }

    private void changeNode(String stringPath, Object context) throws Exception {
        UINodeTreeBuilder builder = (UINodeTreeBuilder)this.getChild(UINodeTreeBuilder.class);
        builder.changeNode(stringPath, context);
    }

    public void changeGroup(String groupId, Object context) throws Exception {
        List listLocalPath;
        String stringPath = this.rootTreePath;
        if (!this.rootTreePath.equals("/")) {
            stringPath = stringPath + "/";
        }
        UIBreadcumbs uiBreadcumb = (UIBreadcumbs)this.getChild(UIBreadcumbs.class);
        if (groupId == null) {
            groupId = "";
        }
        if ((listLocalPath = uiBreadcumb.getPath()) == null || listLocalPath.size() == 0) {
            return;
        }
        ArrayList<String> listLocalPathString = new ArrayList<String>();
        for (UIBreadcumbs.LocalPath localPath : listLocalPath) {
            listLocalPathString.add(localPath.getId().trim());
        }
        if (listLocalPathString.contains(groupId)) {
            int i;
            int index = listLocalPathString.indexOf(groupId);
            this.alreadyChangePath = false;
            if (index == listLocalPathString.size() - 1) {
                return;
            }
            for (i = listLocalPathString.size() - 1; i > index; --i) {
                listLocalPathString.remove(i);
                listLocalPath.remove(i);
            }
            this.alreadyChangePath = true;
            uiBreadcumb.setPath(listLocalPath);
            for (i = 0; i < listLocalPathString.size(); ++i) {
                String pathName = (String)listLocalPathString.get(i);
                if (pathName == null && pathName.equals("")) continue;
                stringPath = stringPath + pathName.trim();
                if (i >= listLocalPathString.size() - 1) continue;
                stringPath = stringPath + "/";
            }
            this.changeNode(stringPath, context);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SelectPathActionListener
    extends EventListener<UIBreadcumbs> {
        public void execute(Event<UIBreadcumbs> event) throws Exception {
            UIBreadcumbs uiBreadcumbs = (UIBreadcumbs)event.getSource();
            UIOneNodePathSelector uiOneNodePathSelector = (UIOneNodePathSelector)uiBreadcumbs.getParent();
            String objectId = event.getRequestContext().getRequestParameter("objectId");
            uiBreadcumbs.setSelectPath(objectId);
            String selectGroupId = uiBreadcumbs.getSelectLocalPath().getId();
            uiOneNodePathSelector.changeGroup(selectGroupId, event.getRequestContext());
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiOneNodePathSelector);
        }
    }
}

