/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.data;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import net.fortuna.ical4j.data.FoldingWriter;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.ValidationException;

public class CalendarOutputter {
    private static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");
    private boolean validating;
    private int foldLength;

    public CalendarOutputter() {
        this(true);
    }

    public CalendarOutputter(boolean validating) {
        this(validating, 73);
    }

    public CalendarOutputter(boolean validating, int foldLength) {
        this.validating = validating;
        this.foldLength = foldLength;
    }

    public final void output(Calendar calendar, OutputStream out) throws IOException, ValidationException {
        this.output(calendar, new OutputStreamWriter(out, DEFAULT_CHARSET));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void output(Calendar calendar, Writer out) throws IOException, ValidationException {
        if (this.isValidating()) {
            calendar.validate();
        }
        FoldingWriter writer = new FoldingWriter(out, this.foldLength);
        try {
            writer.write(calendar.toString());
        }
        finally {
            writer.close();
        }
    }

    public final boolean isValidating() {
        return this.validating;
    }

    public final void setValidating(boolean validating) {
        this.validating = validating;
    }
}

