/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.graphics.color;

import java.awt.Color;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceGray;

public class PDColorState
implements Cloneable {
    private static final Log log = LogFactory.getLog(PDColorState.class);
    private static volatile Color iccOverrideColor = Color.getColor("org.apache.pdfbox.ICC_override_color");
    private PDColorSpace colorSpace = new PDDeviceGray();
    private COSArray colorSpaceValue = new COSArray();
    private Color color = null;

    public static void setIccOverrideColor(Color color) {
        iccOverrideColor = color;
    }

    public PDColorState() {
        this.setColorSpaceValue(new float[]{0.0f});
    }

    public Object clone() {
        PDColorState retval = new PDColorState();
        retval.colorSpace = this.colorSpace;
        retval.colorSpaceValue.clear();
        retval.colorSpaceValue.addAll(this.colorSpaceValue);
        return retval;
    }

    public Color getJavaColor() throws IOException {
        if (this.color == null) {
            this.color = this.createColor();
        }
        return this.color;
    }

    private Color createColor() throws IOException {
        float[] components = this.colorSpaceValue.toFloatArray();
        try {
            if (this.colorSpace.getName().equals("DeviceRGB") && components.length == 3) {
                return new Color(components[0], components[1], components[2]);
            }
            Color override = iccOverrideColor;
            ColorSpace cs = this.colorSpace.getJavaColorSpace();
            if (this.colorSpace.getName().equals("Separation") && components.length == 1) {
                return new Color((int)components[0]);
            }
            if (cs instanceof ICC_ColorSpace && override != null) {
                log.warn((Object)"Using an ICC override color to avoid a potential JVM crash (see PDFBOX-511)");
                return override;
            }
            return new Color(cs, components, 1.0f);
        }
        catch (Exception e) {
            log.warn((Object)("Unable to create the color instance " + Arrays.toString(components) + " in color space " + this.colorSpace + "; using black instead"), (Throwable)e);
            return Color.BLACK;
        }
    }

    public PDColorState(COSArray csValues) {
        this.colorSpaceValue = csValues;
    }

    public PDColorSpace getColorSpace() {
        return this.colorSpace;
    }

    public void setColorSpace(PDColorSpace value) {
        this.colorSpace = value;
        this.color = null;
    }

    public float[] getColorSpaceValue() {
        return this.colorSpaceValue.toFloatArray();
    }

    public COSArray getCOSColorSpaceValue() {
        return this.colorSpaceValue;
    }

    public void setColorSpaceValue(float[] value) {
        this.colorSpaceValue.setFloatArray(value);
        this.color = null;
    }
}

