/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.servlet;

import java.io.IOException;
import java.lang.annotation.Annotation;
import javax.context.Conversation;
import javax.faces.context.FacesContext;
import javax.inject.AnnotationLiteral;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.jboss.webbeans.CurrentManager;
import org.jboss.webbeans.conversation.ConversationIdName;
import org.jboss.webbeans.conversation.ConversationManager;

public class ConversationPropagationFilter
implements Filter {
    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        chain.doFilter(request, this.wrapResponse((HttpServletResponse)response));
    }

    private ServletResponse wrapResponse(HttpServletResponse response) {
        return new HttpServletResponseWrapper(response){

            public void sendRedirect(String path) throws IOException {
                Conversation conversation = CurrentManager.rootManager().getInstanceByType(Conversation.class, new Annotation[0]);
                if (conversation.isLongRunning()) {
                    path = new UrlTransformer(path).getRedirectView().getActionUrl().appendConversation(conversation.getId()).encode();
                    CurrentManager.rootManager().getInstanceByType(ConversationManager.class, new Annotation[0]).cleanupConversation();
                }
                super.sendRedirect(path);
            }
        };
    }

    public void init(FilterConfig config) throws ServletException {
    }

    private class UrlTransformer {
        private String URL;
        private FacesContext context;

        private boolean isUrlAbsolute() {
            return this.URL.startsWith("http://") || this.URL.startsWith("https://");
        }

        public UrlTransformer(String URL2) {
            this.URL = URL2;
            this.context = FacesContext.getCurrentInstance();
        }

        public UrlTransformer appendConversation(String cid) {
            String cidName = CurrentManager.rootManager().getInstanceByType(String.class, new Annotation[]{new AnnotationLiteral<ConversationIdName>(){}});
            this.URL = this.URL + (this.URL.indexOf("?") > 0 ? "&" : "?") + cidName + "=" + cid;
            return this;
        }

        public UrlTransformer getRedirectView() {
            if (this.isUrlAbsolute()) {
                String requestPath = this.context.getExternalContext().getRequestContextPath();
                this.URL = this.URL.substring(this.URL.indexOf(requestPath) + requestPath.length());
            } else {
                int lastSlash = this.URL.lastIndexOf("/");
                if (lastSlash > 0) {
                    this.URL = this.URL.substring(lastSlash);
                }
            }
            return this;
        }

        public UrlTransformer getActionUrl() {
            this.URL = this.context.getApplication().getViewHandler().getActionURL(this.context, this.URL);
            return this;
        }

        public String encode() {
            return this.context.getExternalContext().encodeActionURL(this.URL);
        }
    }
}

