/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dependency.plugins;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.dependency.plugins.BasicStatistic;
import org.jboss.dependency.plugins.StateStatistic;

class StateStatistics {
    private Map<String, StateStatistic> states = new ConcurrentHashMap<String, StateStatistic>();

    StateStatistics() {
    }

    public synchronized void addStatistic(String state, String name, long time) {
        StateStatistic stat = this.states.get(state);
        if (stat == null) {
            stat = new StateStatistic(state);
            this.states.put(state, stat);
        }
        stat.addDetail(name, time);
    }

    public String listTimes(boolean details) {
        ArrayList<StateStatistic> stats = new ArrayList<StateStatistic>(this.states.values());
        Collections.sort(stats);
        StringBuilder builder = new StringBuilder();
        builder.append("<table><tr><th>State/Name</th><th>Time (milliseconds)</th></tr>");
        for (StateStatistic stat : stats) {
            builder.append("<tr>");
            builder.append("<td>").append(stat.getName()).append("</td>");
            builder.append("<td>").append(stat.getTime()).append("</td>");
            builder.append("</tr>");
            if (!details) continue;
            ArrayList<BasicStatistic> list = new ArrayList<BasicStatistic>(stat.getDetails().values());
            Collections.sort(list);
            for (BasicStatistic detail : list) {
                builder.append("<tr>");
                builder.append("<td>`-- ").append(detail.getName()).append("</td>");
                builder.append("<td>").append(detail.getTime()).append("</td>");
                builder.append("</tr>");
            }
        }
        builder.append("</table>");
        return builder.toString();
    }
}

