/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.portlet.impl.jsr168.api;

import javax.portlet.PortletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponseWrapper;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.gatein.pc.api.invocation.PortletInvocation;
import org.gatein.pc.api.invocation.response.PortletInvocationResponse;
import org.gatein.pc.api.invocation.response.ResponseProperties;
import org.gatein.pc.portlet.impl.jsr168.PortletUtils;
import org.gatein.pc.portlet.impl.jsr168.api.PortletRequestImpl;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class PortletResponseImpl
implements PortletResponse {
    protected final PortletInvocation invocation;
    protected final PortletRequestImpl preq;
    private String namespace;
    private Document doc;
    private ResponseProperties properties;
    private HttpServletResponseWrapper realResp;

    protected PortletResponseImpl(PortletInvocation invocation, PortletRequestImpl preq) {
        this.invocation = invocation;
        this.preq = preq;
        this.realResp = new HttpServletResponseWrapper(invocation.getDispatchedResponse());
    }

    public abstract PortletInvocationResponse getResponse();

    public String encodeURL(String url) {
        if (url == null) {
            throw new IllegalArgumentException("URL must not be null");
        }
        return this.invocation.getContext().encodeResourceURL(url);
    }

    public void addProperty(String key, String value) throws IllegalArgumentException {
        if (key == null) {
            throw new IllegalArgumentException("Name cannot be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("Value cannot be null");
        }
        this.getProperties().getTransportHeaders().addValue(key, (Object)value);
    }

    public void setProperty(String key, String value) throws IllegalArgumentException {
        if (key == null) {
            throw new IllegalArgumentException("Name cannot be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("Value cannot be null");
        }
        this.getProperties().getTransportHeaders().setValue(key, (Object)value);
    }

    public void addProperty(Cookie cookie) {
        this.getProperties().getCookies().add(cookie);
    }

    public void addProperty(String key, Element element) {
        this.getProperties().getMarkupHeaders().addValue(key, (Object)element);
    }

    public Element createElement(String tagName) throws DOMException {
        if (this.doc == null) {
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                this.doc = factory.newDocumentBuilder().newDocument();
            }
            catch (ParserConfigurationException e) {
                throw new IllegalStateException("Could not create a document builder factory", e);
            }
        }
        return this.doc.createElement(tagName);
    }

    public String getNamespace() {
        if (this.namespace == null) {
            String windowId = this.invocation.getWindowContext().getId();
            this.namespace = PortletUtils.generateNamespaceFrom(windowId);
        }
        return this.namespace;
    }

    public final HttpServletResponseWrapper getRealResponse() {
        return this.realResp;
    }

    protected final ResponseProperties getProperties() {
        return this.getProperties(true);
    }

    protected final ResponseProperties getProperties(boolean create) {
        if (this.properties == null && create) {
            this.properties = new ResponseProperties();
        }
        return this.properties;
    }
}

