/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.search;

import java.util.HashMap;
import javax.jcr.Node;
import javax.jcr.query.QueryResult;
import org.apache.commons.lang.ArrayUtils;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.services.wcm.publication.WCMComposer;
import org.exoplatform.services.wcm.search.PaginatedQueryResult;
import org.exoplatform.services.wcm.search.QueryCriteria;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

public class WCMPaginatedQueryResult
extends PaginatedQueryResult {
    private long queryTime;
    private String spellSuggestion;

    public WCMPaginatedQueryResult(int pageSize) {
        super(pageSize);
    }

    public WCMPaginatedQueryResult(QueryResult queryResult, QueryCriteria queryCriteria, int pageSize, boolean isSearchContent) throws Exception {
        super(queryResult, pageSize);
        this.queryCriteria = queryCriteria;
    }

    public void setQueryTime(long time) {
        this.queryTime = time;
    }

    public float getQueryTimeInSecond() {
        return (float)this.queryTime / 1000.0f;
    }

    public QueryCriteria getQueryCriteria() {
        return this.queryCriteria;
    }

    public void setQueryCriteria(QueryCriteria queryCriteria) {
        this.queryCriteria = queryCriteria;
    }

    protected Node filterNodeToDisplay(Node node, boolean isSearchContent) throws Exception {
        Node displayNode = this.getNodeToCheckState(node);
        if (displayNode == null) {
            return null;
        }
        if (isSearchContent) {
            return displayNode;
        }
        NodeLocation nodeLocation = NodeLocation.make((Node)displayNode);
        WCMComposer wcmComposer = (WCMComposer)WCMCoreUtils.getService(WCMComposer.class);
        HashMap<String, String> filters = new HashMap<String, String>();
        filters.put("filter-mode", "Live");
        return wcmComposer.getContent(nodeLocation.getRepository(), nodeLocation.getWorkspace(), nodeLocation.getPath(), filters, WCMCoreUtils.getSystemSessionProvider());
    }

    protected Node getNodeToCheckState(Node node) throws Exception {
        String primaryNodeType;
        Object[] contentTypes;
        Node displayNode = node;
        if (node.getPath().contains("web contents/site artifacts")) {
            return null;
        }
        if (displayNode.isNodeType("nt:resource")) {
            displayNode = node.getParent();
        }
        if (displayNode.isNodeType("exo:htmlFile")) {
            Node parent = displayNode.getParent();
            if (this.queryCriteria.isSearchWebContent()) {
                if (parent.isNodeType("exo:webContent")) {
                    return parent;
                }
                return null;
            }
            if (parent.isNodeType("exo:webContent")) {
                return null;
            }
            return displayNode;
        }
        if (this.queryCriteria.isSearchWebContent()) {
            if (!this.queryCriteria.isSearchDocument() && !displayNode.isNodeType("exo:webContent")) {
                return null;
            }
            if (this.queryCriteria.isSearchWebpage() && !displayNode.isNodeType("publication:webpagesPublication")) {
                return null;
            }
        } else if (this.queryCriteria.isSearchWebpage()) {
            if (this.queryCriteria.isSearchDocument()) {
                return displayNode;
            }
            if (!displayNode.isNodeType("publication:webpagesPublication")) {
                return null;
            }
        }
        if ((contentTypes = this.queryCriteria.getContentTypes()) != null && contentTypes.length > 0 && !ArrayUtils.contains((Object[])contentTypes, (Object)(primaryNodeType = displayNode.getPrimaryNodeType().getName()))) {
            return null;
        }
        return displayNode;
    }

    public String getSpellSuggestion() {
        return this.spellSuggestion;
    }

    public void setSpellSuggestion(String spellSuggestion) {
        this.spellSuggestion = spellSuggestion;
    }
}

