/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.threads;

import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jboss.threads.RejectionPolicy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OrderedExecutor
implements Executor {
    private final Executor parent;
    private final Runnable runner = new Runner();
    private final Lock lock = new ReentrantLock();
    private final Condition removeCondition = this.lock.newCondition();
    private final Queue<Runnable> queue;
    private boolean running;
    private RejectionPolicy policy;
    private Executor handoffExecutor;

    public OrderedExecutor(Executor parent) {
        this(parent, RejectionPolicy.BLOCK, null);
    }

    public OrderedExecutor(Executor parent, Queue<Runnable> queue) {
        this(parent, queue, RejectionPolicy.BLOCK, null);
    }

    public OrderedExecutor(Executor parent, RejectionPolicy policy, Executor handoffExecutor) {
        this(parent, new LinkedList<Runnable>(), policy, handoffExecutor);
    }

    public OrderedExecutor(Executor parent, Queue<Runnable> queue, RejectionPolicy policy, Executor handoffExecutor) {
        if (parent == null) {
            throw new NullPointerException("parent is null");
        }
        if (queue == null) {
            throw new NullPointerException("queue is null");
        }
        if (policy == null) {
            throw new NullPointerException("policy is null");
        }
        if (policy == RejectionPolicy.HANDOFF && handoffExecutor == null) {
            throw new NullPointerException("handoffExecutor is null");
        }
        this.queue = queue;
        this.parent = parent;
        this.policy = policy;
        this.handoffExecutor = handoffExecutor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Runnable command) {
        block19: {
            try {
                this.lock.lockInterruptibly();
                try {
                    while (!this.queue.offer(command)) {
                        switch (this.policy) {
                            case ABORT: {
                                throw new RejectedExecutionException();
                            }
                            case BLOCK: {
                                this.removeCondition.await();
                                break;
                            }
                            case DISCARD: {
                                return;
                            }
                            case DISCARD_OLDEST: {
                                if (this.queue.poll() == null) break;
                                this.queue.add(command);
                                break;
                            }
                            case HANDOFF: {
                                this.handoffExecutor.execute(command);
                                return;
                            }
                        }
                    }
                    if (this.running) break block19;
                    this.running = true;
                    boolean ok = false;
                    try {
                        this.parent.execute(this.runner);
                        ok = true;
                    }
                    finally {
                        if (!ok) {
                            this.running = false;
                        }
                    }
                }
                finally {
                    this.lock.unlock();
                }
            }
            catch (InterruptedException e) {
                throw new RejectedExecutionException();
            }
        }
    }

    private class Runner
    implements Runnable {
        private Runner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                Runnable task;
                OrderedExecutor.this.lock.lock();
                try {
                    task = (Runnable)OrderedExecutor.this.queue.poll();
                    OrderedExecutor.this.removeCondition.signal();
                    if (task == null) {
                        OrderedExecutor.this.running = false;
                        return;
                    }
                }
                finally {
                    OrderedExecutor.this.lock.unlock();
                }
                try {
                    task.run();
                }
                catch (Throwable throwable) {
                }
            }
        }
    }
}

