/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.client.container;

import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.jms.client.FailoverCommandCenter;
import org.jboss.jms.client.FailoverValve2;
import org.jboss.jms.client.FailureDetector;
import org.jboss.jms.client.delegate.ClientConnectionDelegate;
import org.jboss.jms.client.delegate.ClientSessionDelegate;
import org.jboss.jms.client.delegate.DelegateSupport;
import org.jboss.jms.client.remoting.JMSRemotingConnection;
import org.jboss.jms.client.state.ConnectionState;
import org.jboss.jms.client.state.HierarchicalState;
import org.jboss.jms.exception.MessagingNetworkFailureException;
import org.jboss.logging.Logger;

public class FailoverValveInterceptor
implements Interceptor,
FailureDetector {
    private static final Logger log = Logger.getLogger(FailoverValveInterceptor.class);
    private static boolean trace = log.isTraceEnabled();
    private DelegateSupport delegate;
    private ConnectionState connectionState;

    public String getName() {
        return "FailoverValveInterceptor";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object invoke(Invocation invocation) throws Throwable {
        FailoverCommandCenter fcc;
        if (this.connectionState == null) {
            HierarchicalState hs;
            this.delegate = (DelegateSupport)invocation.getTargetObject();
            for (hs = this.delegate.getState(); hs != null && !(hs instanceof ConnectionState); hs = hs.getParent()) {
            }
            this.connectionState = (ConnectionState)hs;
        }
        if ((fcc = this.connectionState.getFailoverCommandCenter()) == null) {
            return invocation.invokeNext();
        }
        FailoverValve2 valve = fcc.getValve();
        JMSRemotingConnection remotingConnection = null;
        String methodName = ((MethodInvocation)invocation).getMethod().getName();
        if (methodName.equals("startAfterFailover")) {
            return invocation.invokeNext();
        }
        boolean left = false;
        try {
            try {
                valve.enter();
                remotingConnection = fcc.getRemotingConnection();
                Object object = invocation.invokeNext();
                Object var10_10 = null;
                if (left) return object;
                valve.leave();
                return object;
            }
            catch (MessagingNetworkFailureException e) {
                Object object;
                valve.leave();
                left = true;
                log.debug((Object)(this + " detected network failure, putting " + methodName + "() on hold until failover completes"));
                fcc.failureDetected((Throwable)((Object)e), this, remotingConnection);
                if (invocation.getTargetObject() instanceof ClientSessionDelegate && methodName.equals("send") || invocation.getTargetObject() instanceof ClientConnectionDelegate && methodName.equals("sendTransaction")) {
                    log.trace((Object)(this + " caught " + methodName + "() invocation, enabling check for duplicates"));
                    Object[] arguments = ((MethodInvocation)invocation).getArguments();
                    arguments[1] = Boolean.TRUE;
                    ((MethodInvocation)invocation).setArguments(arguments);
                }
                if (!methodName.equals("cancelDelivery") && !methodName.equals("cancelDeliveries")) {
                    log.trace((Object)(this + " resuming " + methodName + "()"));
                    object = invocation.invokeNext();
                    Object var10_12 = null;
                    if (left) return object;
                    valve.leave();
                    return object;
                }
                log.trace((Object)(this + " NOT resuming " + methodName + "(), let it wither and die"));
                object = null;
                Object var10_11 = null;
                if (left) return object;
                valve.leave();
                return object;
            }
            catch (Throwable e) {
                if (!trace) throw e;
                log.trace((Object)(this + " caught not failover-triggering throwable, rethrowing " + e));
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            if (left) throw throwable;
            valve.leave();
            throw throwable;
        }
    }

    public String toString() {
        return "FailoverValveInterceptor." + (this.delegate == null ? "UNITIALIZED" : this.delegate.toString());
    }
}

