/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.plugin;

import java.io.ByteArrayInputStream;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.PrePersist;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.jetbrains.annotations.NotNull;
import org.rhq.core.domain.util.MD5Generator;

@Entity
@NamedQueries(value={@NamedQuery(name="Plugin.findByName", query=" SELECT new org.rhq.core.domain.plugin.Plugin(         p.id,         p.name,         p.path,         p.displayName,         p.enabled,         p.description,         p.help,         p.md5,         p.version,         p.ctime,         p.mtime)    FROM Plugin AS p   WHERE p.name=:name"), @NamedQuery(name="Plugin.findAll", query=" SELECT new org.rhq.core.domain.plugin.Plugin(         p.id,         p.name,         p.path,         p.displayName,         p.enabled,         p.description,         p.help,         p.md5,         p.version,         p.ctime,         p.mtime)    FROM Plugin AS p "), @NamedQuery(name="Plugin.updateAllButContent", query="UPDATE Plugin p    SET p.name = :name,        p.displayName = :displayName,        p.description = :description,        p.enabled = :enabled,        p.help = :help,        p.version = :version,        p.path = :path,        p.md5 = :md5,        p.mtime = :mtime  WHERE p.id = :id")})
@SequenceGenerator(name="SEQ", sequenceName="RHQ_PLUGIN_ID_SEQ")
@Table(name="RHQ_PLUGIN")
public class Plugin
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String TABLE_NAME = "RHQ_PLUGIN";
    public static final String QUERY_FIND_ALL = "Plugin.findAll";
    public static final String QUERY_FIND_BY_NAME = "Plugin.findByName";
    public static final String UPDATE_ALL_BUT_CONTENT = "Plugin.updateAllButContent";
    @Column(name="ID", nullable=false)
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="SEQ")
    @Id
    private int id;
    @Column(name="NAME", nullable=false)
    private String name;
    @Column(name="DISPLAY_NAME", nullable=false)
    private String displayName;
    @Column(name="DESCRIPTION", nullable=true)
    private String description;
    @Column(name="ENABLED", nullable=false)
    private boolean enabled = true;
    @Column(name="HELP", nullable=true)
    private String help;
    @Column(name="VERSION", nullable=true)
    private String version;
    @Column(name="PATH", nullable=false)
    private String path;
    @Column(name="MD5", nullable=false)
    private String md5;
    @Column(name="CTIME", nullable=false)
    private long ctime;
    @Column(name="MTIME", nullable=false)
    private long mtime;
    @Column(name="CONTENT", nullable=true)
    private byte[] content;

    protected Plugin() {
    }

    public Plugin(@NotNull String name, String path) {
        this.name = name;
        this.path = path;
    }

    public Plugin(String name, String path, String md5) {
        this.name = name;
        this.path = path;
        this.md5 = md5;
    }

    public Plugin(String name, String path, byte[] content) {
        this.name = name;
        this.path = path;
        this.content = content;
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream(content);
            this.md5 = MD5Generator.getDigestString(stream);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot determine plugin's MD5!", e);
        }
    }

    public Plugin(int id, String name, String path, String displayName, boolean enabled, String description, String help, String md5, String version, long ctime, long mtime) {
        this.id = id;
        this.name = name;
        this.path = path;
        this.displayName = displayName;
        this.enabled = enabled;
        this.description = description;
        this.help = help;
        this.md5 = md5;
        this.version = version;
        this.ctime = ctime;
        this.mtime = mtime;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public long getCtime() {
        return this.ctime;
    }

    public void setCtime(long ctime) {
        this.ctime = ctime;
    }

    public long getMtime() {
        return this.mtime;
    }

    public void setMtime(long mtime) {
        this.mtime = mtime;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getHelp() {
        return this.help;
    }

    public void setHelp(String help) {
        this.help = help;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getMd5() {
        return this.md5;
    }

    public void setMd5(String md5) {
        this.md5 = md5;
    }

    public String getMD5() {
        return this.getMd5();
    }

    public void setMD5(String md5) {
        this.setMd5(md5);
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public byte[] getContent() {
        return this.content;
    }

    public void setContent(byte[] content) {
        this.content = content;
    }

    @PrePersist
    void onPersist() {
        this.ctime = System.currentTimeMillis();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof Plugin)) {
            return false;
        }
        Plugin that = (Plugin)obj;
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return "Plugin[id=" + this.id + ", name=" + this.name + ", md5=" + this.md5 + "]";
    }
}

