/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.vfs.plugins.structure;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jboss.deployers.client.spi.Deployment;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.structure.ClassPathEntry;
import org.jboss.deployers.spi.structure.ContextInfo;
import org.jboss.deployers.spi.structure.ModificationType;
import org.jboss.deployers.spi.structure.StructureMetaData;
import org.jboss.deployers.structure.spi.DeploymentContext;
import org.jboss.deployers.structure.spi.helpers.AbstractStructureBuilder;
import org.jboss.deployers.vfs.plugins.structure.AbstractVFSDeploymentContext;
import org.jboss.deployers.vfs.plugins.structure.SecurityActions;
import org.jboss.deployers.vfs.plugins.structure.modify.ModificationAction;
import org.jboss.deployers.vfs.plugins.structure.modify.ModificationActions;
import org.jboss.deployers.vfs.spi.client.VFSDeployment;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentContext;
import org.jboss.logging.Logger;
import org.jboss.virtual.VFSUtils;
import org.jboss.virtual.VirtualFile;
import org.jboss.virtual.VirtualFileFilter;
import org.jboss.virtual.VisitorAttributes;
import org.jboss.virtual.plugins.vfs.helpers.SuffixMatchFilter;

public class VFSStructureBuilder
extends AbstractStructureBuilder {
    private static final Logger log = Logger.getLogger(VFSStructureBuilder.class);

    protected DeploymentContext createRootDeploymentContext(Deployment deployment, StructureMetaData metaData) throws Exception {
        if (deployment instanceof VFSDeployment) {
            VFSDeployment vfsDeployment = (VFSDeployment)deployment;
            String name = deployment.getName();
            String simpleName = deployment.getSimpleName();
            VirtualFile root = this.applyModification(vfsDeployment.getRoot(), metaData.getContext(""));
            if (name == null) {
                return new AbstractVFSDeploymentContext(root, "");
            }
            if (simpleName == null) {
                return new AbstractVFSDeploymentContext(name, name, root, "");
            }
            return new AbstractVFSDeploymentContext(name, simpleName, root, "");
        }
        return super.createRootDeploymentContext(deployment);
    }

    protected DeploymentContext createChildDeploymentContext(DeploymentContext parent, ContextInfo child) throws Exception {
        if (parent instanceof VFSDeploymentContext) {
            VFSDeploymentContext vfsParent = (VFSDeploymentContext)parent;
            String path = child.getPath();
            try {
                VirtualFile parentFile = vfsParent.getRoot();
                VirtualFile file = parentFile.findChild(path);
                return new AbstractVFSDeploymentContext(this.applyModification(file, child), path);
            }
            catch (Throwable t) {
                throw DeploymentException.rethrowAsDeploymentException((String)("Unable to determine child " + path + " from parent " + vfsParent.getRoot().getName()), (Throwable)t);
            }
        }
        return super.createChildDeploymentContext(parent, child);
    }

    protected VirtualFile applyModification(VirtualFile file, ContextInfo contextInfo) throws Exception {
        if (contextInfo == null) {
            return file;
        }
        VirtualFile modified = file;
        ModificationType modificationType = contextInfo.getModificationType();
        if (modificationType != null) {
            ModificationAction action = ModificationActions.getAction(modificationType);
            if (action != null) {
                boolean trace = log.isTraceEnabled();
                if (trace) {
                    log.trace((Object)("Modifying file: " + file + ", modification type: " + modificationType));
                }
                modified = action.modify(file);
                if (trace) {
                    if (modified != file) {
                        log.trace((Object)("Modified file: " + modified));
                    } else {
                        log.trace((Object)("File already modified: " + modified));
                    }
                }
            } else {
                log.info((Object)("Modification " + modificationType + " is not yet supported: " + file));
            }
        }
        return modified;
    }

    protected void applyContextInfo(DeploymentContext context, ContextInfo contextInfo) throws Exception {
        super.applyContextInfo(context, contextInfo);
        if (context instanceof VFSDeploymentContext) {
            boolean trace = log.isTraceEnabled();
            if (trace) {
                log.trace((Object)("Apply context: " + context.getName() + " " + contextInfo));
            }
            VFSDeploymentContext vfsContext = (VFSDeploymentContext)context;
            List metaDataPath = contextInfo.getMetaDataPath();
            if (metaDataPath != null && !metaDataPath.isEmpty()) {
                vfsContext.setMetaDataPath(contextInfo.getMetaDataPath());
            }
            boolean classPathHadVF = false;
            List classPathEntries = contextInfo.getClassPath();
            VFSDeploymentContext top = vfsContext.getTopLevel();
            VirtualFile root = top.getRoot();
            ArrayList<VirtualFile> classPath = new ArrayList<VirtualFile>();
            if (classPathEntries != null) {
                for (ClassPathEntry entry : classPathEntries) {
                    VirtualFile child;
                    if (trace) {
                        log.trace((Object)("Resolving classpath entry " + entry + " for " + context.getName()));
                    }
                    String suffixes = entry.getSuffixes();
                    if (entry.getPath().length() == 0) {
                        child = root;
                    } else {
                        try {
                            child = root.findChild(entry.getPath());
                        }
                        catch (Throwable t) {
                            throw DeploymentException.rethrowAsDeploymentException((String)("Unable to find class path entry " + entry + " from " + root.getName()), (Throwable)t);
                        }
                    }
                    if (suffixes == null) {
                        classPath.add(child);
                        if (classPathHadVF) continue;
                        classPathHadVF = child.equals((Object)root);
                        continue;
                    }
                    String[] suffs = suffixes.split(",");
                    SuffixMatchFilter filter = new SuffixMatchFilter(Arrays.asList(suffs), VisitorAttributes.DEFAULT);
                    List matches = child.getChildren((VirtualFileFilter)filter);
                    if (matches == null) continue;
                    classPath.addAll(matches);
                    if (trace) {
                        log.trace((Object)("Added classpath matches: " + matches));
                    }
                    for (VirtualFile file : matches) {
                        VFSUtils.addManifestLocations((VirtualFile)file, classPath);
                        if (classPathHadVF) continue;
                        classPathHadVF = file.equals((Object)root);
                    }
                }
            }
            VirtualFile file = vfsContext.getRoot();
            if (!classPathHadVF && !SecurityActions.isLeaf(file)) {
                VFSUtils.addManifestLocations((VirtualFile)file, classPath);
            }
            if (!classPath.isEmpty()) {
                vfsContext.setClassPath(classPath);
            }
        }
    }
}

